/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nullable;

public final class MCSetDiagnosticsConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x202700;
    public static final int RESPONSE_MESSAGE_TYPE = 2107137;
    private static final int REQUEST_ENABLED_FIELD_OFFSET = 16;
    private static final int REQUEST_INCLUDE_EPOCH_TIME_FIELD_OFFSET = 17;
    private static final int REQUEST_MAX_ROLLED_FILE_SIZE_IN_MB_FIELD_OFFSET = 18;
    private static final int REQUEST_MAX_ROLLED_FILE_COUNT_FIELD_OFFSET = 22;
    private static final int REQUEST_AUTO_OFF_DURATION_IN_MINUTES_FIELD_OFFSET = 26;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 30;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MCSetDiagnosticsConfigCodec() {
    }

    public static ClientMessage encodeRequest(boolean enabled, String outputType, boolean includeEpochTime, float maxRolledFileSizeInMB, int maxRolledFileCount, String logDirectory, @Nullable String fileNamePrefix, @Nullable Map<String, String> properties, int autoOffDurationInMinutes) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("MC.SetDiagnosticsConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x202700);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, enabled);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, includeEpochTime);
        FixedSizeTypesCodec.encodeFloat(initialFrame.content, 18, maxRolledFileSizeInMB);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 22, maxRolledFileCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 26, autoOffDurationInMinutes);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, outputType);
        StringCodec.encode(clientMessage, logDirectory);
        CodecUtil.encodeNullable(clientMessage, fileNamePrefix, StringCodec::encode);
        MapCodec.encodeNullable(clientMessage, properties, StringCodec::encode, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.includeEpochTime = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        request.maxRolledFileSizeInMB = FixedSizeTypesCodec.decodeFloat(initialFrame.content, 18);
        request.maxRolledFileCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 22);
        request.autoOffDurationInMinutes = FixedSizeTypesCodec.decodeInt(initialFrame.content, 26);
        request.outputType = StringCodec.decode(iterator);
        request.logDirectory = StringCodec.decode(iterator);
        request.fileNamePrefix = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.properties = MapCodec.decodeNullable(iterator, StringCodec::decode, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2107137);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public boolean enabled;
        public String outputType;
        public boolean includeEpochTime;
        public float maxRolledFileSizeInMB;
        public int maxRolledFileCount;
        public String logDirectory;
        @Nullable
        public String fileNamePrefix;
        @Nullable
        public Map<String, String> properties;
        public int autoOffDurationInMinutes;
    }
}

