/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.annotation.Nullable;

public final class MCGetDiagnosticsConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x202800;
    public static final int RESPONSE_MESSAGE_TYPE = 2107393;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_ENABLED_FIELD_OFFSET = 13;
    private static final int RESPONSE_INCLUDE_EPOCH_TIME_FIELD_OFFSET = 14;
    private static final int RESPONSE_MAX_ROLLED_FILE_SIZE_IN_MB_FIELD_OFFSET = 15;
    private static final int RESPONSE_MAX_ROLLED_FILE_COUNT_FIELD_OFFSET = 19;
    private static final int RESPONSE_AUTO_OFF_DURATION_IN_MINUTES_FIELD_OFFSET = 23;
    private static final int RESPONSE_CAN_BE_CONFIGURED_DYNAMICALLY_FIELD_OFFSET = 27;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 28;

    private MCGetDiagnosticsConfigCodec() {
    }

    public static ClientMessage encodeRequest() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MC.GetDiagnosticsConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x202800);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ClientMessage encodeResponse(boolean enabled, String outputType, boolean includeEpochTime, float maxRolledFileSizeInMB, int maxRolledFileCount, String logDirectory, @Nullable String fileNamePrefix, @Nullable Map<String, String> properties, int autoOffDurationInMinutes, boolean canBeConfiguredDynamically) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[28], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2107393);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, enabled);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 14, includeEpochTime);
        FixedSizeTypesCodec.encodeFloat(initialFrame.content, 15, maxRolledFileSizeInMB);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 19, maxRolledFileCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 23, autoOffDurationInMinutes);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 27, canBeConfiguredDynamically);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, outputType);
        StringCodec.encode(clientMessage, logDirectory);
        CodecUtil.encodeNullable(clientMessage, fileNamePrefix, StringCodec::encode);
        MapCodec.encodeNullable(clientMessage, properties, StringCodec::encode, StringCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        response.includeEpochTime = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 14);
        response.maxRolledFileSizeInMB = FixedSizeTypesCodec.decodeFloat(initialFrame.content, 15);
        response.maxRolledFileCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 19);
        response.autoOffDurationInMinutes = FixedSizeTypesCodec.decodeInt(initialFrame.content, 23);
        response.canBeConfiguredDynamically = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 27);
        response.outputType = StringCodec.decode(iterator);
        response.logDirectory = StringCodec.decode(iterator);
        response.fileNamePrefix = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        response.properties = MapCodec.decodeNullable(iterator, StringCodec::decode, StringCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public boolean enabled;
        public String outputType;
        public boolean includeEpochTime;
        public float maxRolledFileSizeInMB;
        public int maxRolledFileCount;
        public String logDirectory;
        @Nullable
        public String fileNamePrefix;
        @Nullable
        public Map<String, String> properties;
        public int autoOffDurationInMinutes;
        public boolean canBeConfiguredDynamically;
    }
}

