/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ListAddListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 330496;
    public static final int RESPONSE_MESSAGE_TYPE = 330497;
    private static final int REQUEST_INCLUDE_VALUE_FIELD_OFFSET = 16;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 17;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 18;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_ITEM_UUID_FIELD_OFFSET = 16;
    private static final int EVENT_ITEM_EVENT_TYPE_FIELD_OFFSET = 33;
    private static final int EVENT_ITEM_INITIAL_FRAME_SIZE = 37;
    private static final int EVENT_ITEM_MESSAGE_TYPE = 330498;

    private ListAddListenerCodec() {
    }

    public static ClientMessage encodeRequest(String name, boolean includeValue, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("List.AddListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[18], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 330496);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, includeValue);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 17, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.includeValue = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 17);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 330497);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeItemEvent(@Nullable Data item, UUID uuid, int eventType) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[37], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 330498);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, uuid);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 33, eventType);
        clientMessage.add(initialFrame);
        DataCodec.encodeNullable(clientMessage, item);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public boolean includeValue;
        public boolean localOnly;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 330498) {
                ClientMessage.Frame initialFrame = iterator.next();
                UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
                int eventType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 33);
                Data item = DataCodec.decodeNullable(iterator);
                this.handleItemEvent(item, uuid, eventType);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleItemEvent(@Nullable Data var1, UUID var2, int var3);
    }
}

