/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ExecutorServiceSubmitToMemberCodec {
    public static final int REQUEST_MESSAGE_TYPE = 525824;
    public static final int RESPONSE_MESSAGE_TYPE = 525825;
    private static final int REQUEST_UUID_FIELD_OFFSET = 16;
    private static final int REQUEST_MEMBER_UUID_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 50;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private ExecutorServiceSubmitToMemberCodec() {
    }

    public static ClientMessage encodeRequest(String name, UUID uuid, Data callable, UUID memberUUID) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("ExecutorService.SubmitToMember");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[50], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 525824);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, uuid);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 33, memberUUID);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, callable);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.memberUUID = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 33);
        request.name = StringCodec.decode(iterator);
        request.callable = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable Data response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 525825);
        clientMessage.add(initialFrame);
        DataCodec.encodeNullable(clientMessage, response);
        return clientMessage;
    }

    public static Data decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        iterator.next();
        return DataCodec.decodeNullable(iterator);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public UUID uuid;
        public Data callable;
        public UUID memberUUID;
    }
}

