/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.VectorIndexConfigCodec;
import com.hazelcast.config.vector.VectorIndexConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddVectorCollectionConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1774592;
    public static final int RESPONSE_MESSAGE_TYPE = 1774593;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 16;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 28;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddVectorCollectionConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, List<VectorIndexConfig> indexConfigs, int backupCount, int asyncBackupCount, @Nullable String splitBrainProtectionName, String mergePolicy, int mergeBatchSize, @Nullable String userCodeNamespace) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddVectorCollectionConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[28], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1774592);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, mergeBatchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        ListMultiFrameCodec.encode(clientMessage, indexConfigs, VectorIndexConfigCodec::encode);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        StringCodec.encode(clientMessage, mergePolicy);
        CodecUtil.encodeNullable(clientMessage, userCodeNamespace, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        if (initialFrame.content.length >= 20) {
            request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
            request.isBackupCountExists = true;
        } else {
            request.isBackupCountExists = false;
        }
        if (initialFrame.content.length >= 24) {
            request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
            request.isAsyncBackupCountExists = true;
        } else {
            request.isAsyncBackupCountExists = false;
        }
        if (initialFrame.content.length >= 28) {
            request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
            request.isMergeBatchSizeExists = true;
        } else {
            request.isMergeBatchSizeExists = false;
        }
        request.name = StringCodec.decode(iterator);
        request.indexConfigs = ListMultiFrameCodec.decode(iterator, VectorIndexConfigCodec::decode);
        if (iterator.hasNext()) {
            request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
            request.isSplitBrainProtectionNameExists = true;
        } else {
            request.isSplitBrainProtectionNameExists = false;
        }
        if (iterator.hasNext()) {
            request.mergePolicy = StringCodec.decode(iterator);
            request.isMergePolicyExists = true;
        } else {
            request.isMergePolicyExists = false;
        }
        if (iterator.hasNext()) {
            request.userCodeNamespace = CodecUtil.decodeNullable(iterator, StringCodec::decode);
            request.isUserCodeNamespaceExists = true;
        } else {
            request.isUserCodeNamespaceExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1774593);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public List<VectorIndexConfig> indexConfigs;
        public int backupCount;
        public int asyncBackupCount;
        @Nullable
        public String splitBrainProtectionName;
        public String mergePolicy;
        public int mergeBatchSize;
        @Nullable
        public String userCodeNamespace;
        public boolean isBackupCountExists;
        public boolean isAsyncBackupCountExists;
        public boolean isSplitBrainProtectionNameExists;
        public boolean isMergePolicyExists;
        public boolean isMergeBatchSizeExists;
        public boolean isUserCodeNamespaceExists;
    }
}

