/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class CachePutCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x131300;
    public static final int RESPONSE_MESSAGE_TYPE = 0x131301;
    private static final int REQUEST_GET_FIELD_OFFSET = 16;
    private static final int REQUEST_COMPLETION_ID_FIELD_OFFSET = 17;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 21;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private CachePutCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data key, Data value, @Nullable Data expiryPolicy, boolean get, int completionId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Cache.Put");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x131300);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, get);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 17, completionId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, key);
        DataCodec.encode(clientMessage, value);
        DataCodec.encodeNullable(clientMessage, expiryPolicy);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.get = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.completionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 17);
        request.name = StringCodec.decode(iterator);
        request.key = DataCodec.decode(iterator);
        request.value = DataCodec.decode(iterator);
        request.expiryPolicy = DataCodec.decodeNullable(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable Data response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x131301);
        clientMessage.add(initialFrame);
        DataCodec.encodeNullable(clientMessage, response);
        return clientMessage;
    }

    public static Data decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        iterator.next();
        return DataCodec.decodeNullable(iterator);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data key;
        public Data value;
        @Nullable
        public Data expiryPolicy;
        public boolean get;
        public int completionId;
    }
}

