/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPGroupsSnapshot;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.version.Version;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public final class KeyValuePairGenerator {
    public static final String GROUPS = "groups";
    public static final String VERSION = "version";

    private KeyValuePairGenerator() {
    }

    public static Map<String, String> createKeyValuePairs(Collection<Collection<UUID>> memberGroups, int version, boolean enterprise, Version clusterVersion, CPGroupsSnapshot cpMemberSnapshot) {
        HashMap<String, String> keyValuePairs = new HashMap<String, String>();
        keyValuePairs.put("clusterVersion", clusterVersion.toString());
        if (enterprise) {
            keyValuePairs.put("memberGroups", KeyValuePairGenerator.toJsonString(memberGroups, version));
            if (!cpMemberSnapshot.getAllGroupInformation().isEmpty()) {
                keyValuePairs.put("cp.leaders", KeyValuePairGenerator.toJsonString(cpMemberSnapshot));
            }
        }
        return keyValuePairs;
    }

    private static String toJsonString(CPGroupsSnapshot cpMemberSnapshot) {
        if (cpMemberSnapshot.getAllGroupInformation().isEmpty()) {
            return "[]";
        }
        Map<CPGroupId, UUID> leadersInfo = cpMemberSnapshot.getAllGroupInformation().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<CPGroupId, UUID>((CPGroupId)entry.getKey(), cpMemberSnapshot.getApUuid(((CPGroupsSnapshot.GroupInfo)entry.getValue()).leader()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        JsonArray baseArray = Json.array();
        for (Map.Entry<CPGroupId, UUID> entry2 : leadersInfo.entrySet()) {
            CPGroupId cPGroupId = entry2.getKey();
            if (cPGroupId instanceof RaftGroupId) {
                RaftGroupId raftId = (RaftGroupId)cPGroupId;
                JsonObject baseObject = Json.object();
                baseObject.add("raftId", Json.object().add("name", raftId.getName()).add("id", raftId.getId()).add("seed", raftId.getSeed()));
                baseObject.add("leaderUUID", entry2.getValue().toString());
                baseArray.add(baseObject);
                continue;
            }
            throw new IllegalArgumentException("Unknown CPGroupId class provided: " + String.valueOf(entry2.getKey()));
        }
        return baseArray.toString();
    }

    public static Map<CPGroupId, UUID> parseJsonForCPMembership(String jsonArray) {
        if (jsonArray.equals("[]")) {
            return Collections.emptyMap();
        }
        JsonArray baseArray = Json.parse(jsonArray).asArray();
        HashMap<CPGroupId, UUID> leadersMap = new HashMap<CPGroupId, UUID>(baseArray.size());
        for (JsonValue entry : baseArray) {
            JsonObject baseObject = entry.asObject();
            JsonValue raftIdValue = baseObject.get("raftId");
            JsonValue leaderUUIDValue = baseObject.get("leaderUUID");
            if (raftIdValue == null || leaderUUIDValue == null) {
                throw new IllegalArgumentException("Invalid Json string received for CP group view: " + jsonArray);
            }
            JsonObject raftIdObject = raftIdValue.asObject();
            RaftGroupId raftGroupId = new RaftGroupId(raftIdObject.get("name").asString(), raftIdObject.get("seed").asLong(), raftIdObject.get("id").asLong());
            UUID leaderUUID = UUID.fromString(leaderUUIDValue.asString());
            leadersMap.put(raftGroupId, leaderUUID);
        }
        return leadersMap;
    }

    private static String toJsonString(Collection<Collection<UUID>> memberGroups, int version) {
        JsonObject root = new JsonObject();
        root.add(VERSION, version);
        JsonArray allMemberGroups = new JsonArray();
        for (Collection<UUID> groupUuids : memberGroups) {
            JsonArray memberGroup = new JsonArray();
            for (UUID memberUuid : groupUuids) {
                memberGroup.add(memberUuid.toString());
            }
            allMemberGroups.add(memberGroup);
        }
        root.add(GROUPS, allMemberGroups);
        return root.toString();
    }

    public static MemberGroupsAndVersionHolder parseJsonForMemberGroups(String memberGroupsJsonString) {
        JsonValue value = Json.parse(memberGroupsJsonString);
        JsonObject root = value.asObject();
        JsonValue versionValue = root.get(VERSION);
        int version = versionValue.asInt();
        HashSet<Collection<UUID>> allMemberGroups = new HashSet<Collection<UUID>>();
        JsonArray groups = JsonUtil.getArray(root, GROUPS);
        List<JsonValue> uuidArrays = groups.values();
        for (JsonValue uuidArrayValue : uuidArrays) {
            JsonArray uuidArray = uuidArrayValue.asArray();
            HashSet<UUID> memberGroup = new HashSet<UUID>();
            for (JsonValue uuidValue : uuidArray.values()) {
                UUID uuid = UUID.fromString(uuidValue.asString());
                memberGroup.add(uuid);
            }
            allMemberGroups.add(memberGroup);
        }
        return new MemberGroupsAndVersionHolder(allMemberGroups, version);
    }

    public record MemberGroupsAndVersionHolder(Collection<Collection<UUID>> allMemberGroups, int version) {
    }
}

