/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.AbstractListenerService;
import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddClusterViewListenerCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.cluster.impl.MembershipManager;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.impl.PartitionStateManagerImpl;
import com.hazelcast.internal.util.scheduler.CoalescingDelayedTrigger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class ClusterViewListenerService
extends AbstractListenerService {
    private static final long PARTITION_UPDATE_DELAY_MS = 100L;
    private static final long PARTITION_UPDATE_MAX_DELAY_MS = 500L;
    private final boolean advancedNetworkConfigEnabled;
    private final CoalescingDelayedTrigger delayedPartitionUpdateTrigger;
    private final AtomicInteger partitionTableVersion = new AtomicInteger();
    private final AtomicLong latestPartitionStamp = new AtomicLong();

    ClusterViewListenerService(NodeEngineImpl nodeEngine) {
        super(nodeEngine, nodeEngine.getLogger(ClusterViewListenerService.class), null);
        this.advancedNetworkConfigEnabled = nodeEngine.getConfig().getAdvancedNetworkConfig().isEnabled();
        this.delayedPartitionUpdateTrigger = new CoalescingDelayedTrigger(nodeEngine.getExecutionService(), 100L, 500L, this::pushPartitionTableView);
    }

    @Override
    protected void pushView() {
        this.pushPartitionTableView();
        MembersView membersView = this.getMembersView();
        ClientMessage memberListViewMessage = this.getMemberListViewMessage(membersView);
        this.logger.finest("Sending members view to all listening clients: %s", membersView);
        this.sendToListeningEndpoints(memberListViewMessage);
        Collection<Collection<UUID>> memberGroups = this.toMemberGroups(membersView);
        ClientMessage memberGroupsViewEvent = ClientAddClusterViewListenerCodec.encodeMemberGroupsViewEvent(membersView.getVersion(), memberGroups);
        this.logger.finest("Sending member groups to all listening clients: %s", memberGroups);
        this.sendToListeningEndpoints(memberGroupsViewEvent);
        ClientMessage clusterVersionMessage = this.getClusterVersionMessage();
        this.logger.finest("Sending cluster version to all listening clients: %s", clusterVersionMessage);
        this.sendToListeningEndpoints(clusterVersionMessage);
    }

    private void pushPartitionTableView() {
        ClientMessage partitionViewMessage = this.getPartitionViewMessage();
        if (partitionViewMessage != null) {
            this.logger.finest("Sending partition table view to all listening clients: %s", partitionViewMessage);
            this.sendToListeningEndpoints(partitionViewMessage);
        }
    }

    public void onPartitionStateChange() {
        this.delayedPartitionUpdateTrigger.executeWithDelay();
    }

    public void onMemberListChange() {
        MembersView membersView = this.getMembersView();
        this.logger.finest("Sending members view to all listening clients: %s", membersView);
        this.sendToListeningEndpoints(this.getMemberListViewMessage(membersView));
    }

    public void onClusterVersionChange() {
        ClientMessage clusterVersionMessage = this.getClusterVersionMessage();
        this.logger.finest("Sending cluster version to all listening clients: %s", clusterVersionMessage);
        this.sendToListeningEndpoints(clusterVersionMessage);
    }

    @Override
    protected void sendUpdate(ClientEndpoint clientEndpoint, Connection connection, long correlationId) {
        MembersView processedMembersView = this.getMembersView();
        ClientMessage memberListViewMessage = this.getMemberListViewMessage(processedMembersView);
        memberListViewMessage.setCorrelationId(correlationId);
        this.write(memberListViewMessage, connection);
        ClientMessage partitionViewMessage = this.getPartitionViewMessage();
        if (partitionViewMessage != null) {
            partitionViewMessage.setCorrelationId(correlationId);
            this.write(partitionViewMessage, connection);
        }
        int version = processedMembersView.getVersion();
        Collection<Collection<UUID>> memberGroups = this.toMemberGroups(processedMembersView);
        ClientMessage memberGroupsViewEvent = ClientAddClusterViewListenerCodec.encodeMemberGroupsViewEvent(version, memberGroups);
        memberGroupsViewEvent.setCorrelationId(correlationId);
        this.write(memberGroupsViewEvent, clientEndpoint.getConnection());
        ClientMessage clusterVersionMessage = this.getClusterVersionMessage();
        clusterVersionMessage.setCorrelationId(correlationId);
        this.write(clusterVersionMessage, connection);
        this.logger.finest("Sent cluster view update to %s: members view: %s, partition table: %s, member groups: %s, cluster version: %s", connection, processedMembersView, partitionViewMessage, memberGroups, clusterVersionMessage);
    }

    public MembersView getMembersView() {
        MembershipManager membershipManager = ((ClusterServiceImpl)this.nodeEngine.getClusterService()).getMembershipManager();
        MembersView membersView = membershipManager.getMembersView();
        int version = membersView.getVersion();
        List<MemberInfo> members = membersView.getMembers();
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
        for (MemberInfo member : members) {
            Address address = this.clientAddressOf(member.getAddress());
            if (address == null) continue;
            memberInfos.add(new MemberInfo(address, member.getUuid(), member.getAttributes(), member.isLiteMember(), member.getVersion(), member.getAddressMap()));
        }
        return new MembersView(version, memberInfos);
    }

    @Nullable
    public PartitionsView getPartitionsView() {
        long latestStamp;
        InternalPartitionService partitionService = (InternalPartitionService)this.nodeEngine.getPartitionService();
        PartitionTableView partitionTableView = partitionService.createPartitionTableView();
        Map<UUID, List<Integer>> partitions = this.getPartitions(partitionTableView);
        if (partitions.isEmpty()) {
            return null;
        }
        long currentStamp = partitionTableView.stamp();
        if (currentStamp != (latestStamp = this.latestPartitionStamp.get()) && this.latestPartitionStamp.compareAndSet(latestStamp, currentStamp)) {
            this.partitionTableVersion.incrementAndGet();
        }
        int version = this.partitionTableVersion.get();
        return new PartitionsView(partitions, version);
    }

    public Collection<Collection<UUID>> toMemberGroups(MembersView membersView) {
        if (!this.nodeEngine.getNode().getBuildInfo().isEnterprise()) {
            return Collections.emptyList();
        }
        ArrayList<Member> list = new ArrayList<Member>(membersView.size());
        List<MemberInfo> members = membersView.getMembers();
        for (MemberInfo memberInfo : members) {
            MemberImpl member = memberInfo.toMember();
            list.add(member);
        }
        PartitionStateManagerImpl partitionStateManager = this.getPartitionStateManager();
        Collection<MemberGroup> memberGroups = partitionStateManager.createMemberGroups(list);
        ArrayList<Collection<UUID>> allUuids = new ArrayList<Collection<UUID>>(memberGroups.size());
        for (MemberGroup memberGroup : memberGroups) {
            ArrayList<UUID> uuids = new ArrayList<UUID>(memberGroup.size());
            Iterator<Member> iterator = memberGroup.iterator();
            while (iterator.hasNext()) {
                Member member = iterator.next();
                uuids.add(member.getUuid());
            }
            allUuids.add(uuids);
        }
        return allUuids;
    }

    private PartitionStateManagerImpl getPartitionStateManager() {
        return (PartitionStateManagerImpl)((InternalPartitionService)this.nodeEngine.getPartitionService()).getPartitionStateManager();
    }

    @Nullable
    private ClientMessage getPartitionViewMessage() {
        PartitionsView partitionsView = this.getPartitionsView();
        if (partitionsView == null) {
            return null;
        }
        return ClientAddClusterViewListenerCodec.encodePartitionsViewEvent(partitionsView.version(), partitionsView.partitions().entrySet());
    }

    private ClientMessage getMemberListViewMessage(MembersView processedMembersView) {
        return ClientAddClusterViewListenerCodec.encodeMembersViewEvent(processedMembersView.getVersion(), processedMembersView.getMembers());
    }

    private ClientMessage getClusterVersionMessage() {
        Version version = this.nodeEngine.getClusterService().getClusterVersion();
        return ClientAddClusterViewListenerCodec.encodeClusterVersionEvent(version);
    }

    private Address clientAddressOf(Address memberAddress) {
        if (!this.advancedNetworkConfigEnabled) {
            return memberAddress;
        }
        MemberImpl member = this.nodeEngine.getClusterService().getMember(memberAddress);
        if (member != null) {
            return member.getAddressMap().get(EndpointQualifier.CLIENT);
        }
        return null;
    }

    public Map<UUID, List<Integer>> getPartitions(PartitionTableView partitionTableView) {
        HashMap<UUID, List<Integer>> partitionsMap = new HashMap<UUID, List<Integer>>();
        int partitionCount = partitionTableView.length();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            PartitionReplica owner = partitionTableView.getReplica(partitionId, 0);
            if (owner == null || owner.uuid() == null) {
                partitionsMap.clear();
                return partitionsMap;
            }
            partitionsMap.computeIfAbsent(owner.uuid(), k -> new LinkedList()).add(partitionId);
        }
        return partitionsMap;
    }

    public record PartitionsView(Map<UUID, List<Integer>> partitions, int version) {
    }
}

