/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpointStatisticsSnapshot;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.counters.MwCounter;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClientEndpointStatistics {
    private final MwCounter connectionsOpened = MwCounter.newMwCounter();
    private final MwCounter connectionsClosed = MwCounter.newMwCounter();
    private final MwCounter totalConnectionDuration = MwCounter.newMwCounter();
    private final Set<String> clientVersions = ConcurrentHashMap.newKeySet();

    public void incrementConnectionsOpenedCount() {
        this.connectionsOpened.inc();
    }

    public void incrementConnectionsClosedCount() {
        this.connectionsClosed.inc();
    }

    public void incrementTotalConnectionDuration(long duration) {
        this.totalConnectionDuration.inc(duration);
    }

    public void addClientVersion(String clientVersion) {
        this.clientVersions.add(clientVersion);
    }

    public ClientEndpointStatisticsSnapshot getSnapshotAndReset() {
        Set<String> clientVersionsSnapshot = SetUtil.createHashSet(this.clientVersions.size());
        clientVersionsSnapshot.addAll(this.clientVersions);
        this.clientVersions.clear();
        return new ClientEndpointStatisticsSnapshot(this.connectionsOpened.getAndSet(0L), this.connectionsClosed.getAndSet(0L), this.totalConnectionDuration.getAndSet(0L), clientVersionsSnapshot);
    }
}

