/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientMetricsConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientSqlConfig;
import com.hazelcast.client.config.ClientSqlResubmissionMode;
import com.hazelcast.client.config.ClientTpcConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ClusterRoutingConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.client.config.RoutingStrategy;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.config.impl.ClientAliasedDiscoveryConfigUtils;
import com.hazelcast.client.config.impl.ClientConfigSections;
import com.hazelcast.client.config.impl.QueryCacheConfigBuilderHelper;
import com.hazelcast.client.config.impl.QueryCacheXmlConfigBuilderHelper;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AutoDetectionConfig;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.security.KerberosIdentityConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.internal.config.AbstractDomConfigProcessor;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.topic.TopicOverloadPolicy;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ClientDomConfigProcessor
extends AbstractDomConfigProcessor {
    private static final ILogger LOGGER = Logger.getLogger(ClientDomConfigProcessor.class);
    protected final ClientConfig clientConfig;
    protected final QueryCacheConfigBuilderHelper queryCacheConfigBuilderHelper;
    protected boolean processedRoutingMode;

    public ClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig) {
        this(domLevel3, clientConfig, new QueryCacheXmlConfigBuilderHelper(domLevel3));
    }

    public ClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig, boolean strict) {
        this(domLevel3, clientConfig, new QueryCacheXmlConfigBuilderHelper(domLevel3), strict);
    }

    ClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig, QueryCacheConfigBuilderHelper queryCacheConfigBuilderHelper) {
        super(domLevel3);
        this.clientConfig = clientConfig;
        this.queryCacheConfigBuilderHelper = queryCacheConfigBuilderHelper;
    }

    ClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig, QueryCacheConfigBuilderHelper queryCacheConfigBuilderHelper, boolean strict) {
        super(domLevel3, strict);
        this.clientConfig = clientConfig;
        this.queryCacheConfigBuilderHelper = queryCacheConfigBuilderHelper;
    }

    @Override
    public void buildConfig(Node rootNode) {
        for (Node node : DomConfigHelper.childElements(rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration");
            }
            this.handleNode(node, nodeName);
            if (ClientConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private void handleNode(Node node, String nodeName) {
        if (this.matches(ClientConfigSections.SECURITY.getName(), nodeName)) {
            this.handleSecurity(node);
        } else if (this.matches(ClientConfigSections.PROXY_FACTORIES.getName(), nodeName)) {
            this.handleProxyFactories(node);
        } else if (this.matches(ClientConfigSections.PROPERTIES.getName(), nodeName)) {
            this.fillProperties(node, this.clientConfig.getProperties());
        } else if (this.matches(ClientConfigSections.SERIALIZATION.getName(), nodeName)) {
            this.handleSerialization(node);
        } else if (this.matches(ClientConfigSections.NATIVE_MEMORY.getName(), nodeName)) {
            this.fillNativeMemoryConfig(node, this.clientConfig.getNativeMemoryConfig());
        } else if (this.matches(ClientConfigSections.LISTENERS.getName(), nodeName)) {
            this.handleListeners(node);
        } else if (this.matches(ClientConfigSections.NETWORK.getName(), nodeName)) {
            this.handleNetwork(node);
        } else if (this.matches(ClientConfigSections.LOAD_BALANCER.getName(), nodeName)) {
            this.handleLoadBalancer(node);
        } else if (this.matches(ClientConfigSections.NEAR_CACHE.getName(), nodeName)) {
            this.handleNearCache(node);
        } else if (this.matches(ClientConfigSections.QUERY_CACHES.getName(), nodeName)) {
            this.queryCacheConfigBuilderHelper.handleQueryCache(this.clientConfig, node);
        } else if (this.matches(ClientConfigSections.INSTANCE_NAME.getName(), nodeName)) {
            this.clientConfig.setInstanceName(this.getTextContent(node));
        } else if (this.matches(ClientConfigSections.CONNECTION_STRATEGY.getName(), nodeName)) {
            this.handleConnectionStrategy(node);
        } else if (this.matches(ClientConfigSections.USER_CODE_DEPLOYMENT.getName(), nodeName)) {
            this.handleUserCodeDeployment(node);
        } else if (this.matches(ClientConfigSections.FLAKE_ID_GENERATOR.getName(), nodeName)) {
            this.handleFlakeIdGenerator(node);
        } else if (this.matches(ClientConfigSections.RELIABLE_TOPIC.getName(), nodeName)) {
            this.handleReliableTopic(node);
        } else if (this.matches(ClientConfigSections.LABELS.getName(), nodeName)) {
            this.handleLabels(node);
        } else if (this.matches(ClientConfigSections.BACKUP_ACK_TO_CLIENT.getName(), nodeName)) {
            this.handleBackupAckToClient(node);
        } else if (this.matches(ClientConfigSections.CLUSTER_NAME.getName(), nodeName)) {
            this.clientConfig.setClusterName(this.getTextContent(node));
        } else if (this.matches(ClientConfigSections.METRICS.getName(), nodeName)) {
            this.handleMetrics(node);
        } else if (this.matches(ClientConfigSections.INSTANCE_TRACKING.getName(), nodeName)) {
            this.handleInstanceTracking(node, this.clientConfig.getInstanceTrackingConfig());
        } else if (this.matches(ClientConfigSections.SQL.getName(), nodeName)) {
            this.handleSql(node, this.clientConfig.getSqlConfig());
        } else if (this.matches(ClientConfigSections.TPC.getName(), nodeName)) {
            this.handleTpc(node, this.clientConfig.getTpcConfig());
        } else if (this.matches(ClientConfigSections.CP_DIRECT_TO_LEADER_ROUTING.getName(), nodeName)) {
            this.clientConfig.setCPDirectToLeaderRoutingEnabled(Boolean.parseBoolean(this.getTextContent(node)));
        }
    }

    private void handleBackupAckToClient(Node node) {
        boolean enabled = Boolean.parseBoolean(this.getTextContent(node));
        this.clientConfig.setBackupAckToClientEnabled(enabled);
    }

    private void handleLabels(Node node) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String value = this.getTextContent(n);
            this.clientConfig.addLabel(value);
        }
    }

    private void handleConnectionStrategy(Node node) {
        ClientConnectionStrategyConfig strategyConfig = this.clientConfig.getConnectionStrategyConfig();
        String attrValue = this.getAttribute(node, "async-start");
        strategyConfig.setAsyncStart(attrValue != null && DomConfigHelper.getBooleanValue(attrValue.trim()));
        attrValue = this.getAttribute(node, "reconnect-mode");
        if (attrValue != null) {
            strategyConfig.setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.valueOf(StringUtil.upperCaseInternal(attrValue.trim())));
        }
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("connection-retry", nodeName)) continue;
            this.handleConnectionRetry(child, strategyConfig);
        }
        this.clientConfig.setConnectionStrategyConfig(strategyConfig);
    }

    private void handleConnectionRetry(Node node, ClientConnectionStrategyConfig strategyConfig) {
        ConnectionRetryConfig connectionRetryConfig = new ConnectionRetryConfig();
        String initialBackoffMillis = "initial-backoff-millis";
        String maxBackoffMillis = "max-backoff-millis";
        String multiplier = "multiplier";
        String jitter = "jitter";
        String timeoutMillis = "cluster-connect-timeout-millis";
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches(initialBackoffMillis, nodeName)) {
                connectionRetryConfig.setInitialBackoffMillis(DomConfigHelper.getIntegerValue(initialBackoffMillis, this.getTextContent(child)));
                continue;
            }
            if (this.matches(maxBackoffMillis, nodeName)) {
                connectionRetryConfig.setMaxBackoffMillis(DomConfigHelper.getIntegerValue(maxBackoffMillis, this.getTextContent(child)));
                continue;
            }
            if (this.matches(multiplier, nodeName)) {
                connectionRetryConfig.setMultiplier(DomConfigHelper.getDoubleValue(multiplier, this.getTextContent(child)));
                continue;
            }
            if (this.matches(timeoutMillis, nodeName)) {
                connectionRetryConfig.setClusterConnectTimeoutMillis(DomConfigHelper.getLongValue(timeoutMillis, this.getTextContent(child)));
                continue;
            }
            if (!this.matches(jitter, nodeName)) continue;
            connectionRetryConfig.setJitter(DomConfigHelper.getDoubleValue(jitter, this.getTextContent(child)));
        }
        strategyConfig.setConnectionRetryConfig(connectionRetryConfig);
    }

    private void handleUserCodeDeployment(Node node) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        ClientUserCodeDeploymentConfig userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        userCodeDeploymentConfig.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleUserCodeDeploymentNode(userCodeDeploymentConfig, child);
        }
        this.clientConfig.setUserCodeDeploymentConfig(userCodeDeploymentConfig);
    }

    protected void handleUserCodeDeploymentNode(ClientUserCodeDeploymentConfig userCodeDeploymentConfig, Node child) {
        String childNodeName = DomConfigHelper.cleanNodeName(child);
        if (this.matches("classnames", childNodeName)) {
            for (Node classNameNode : DomConfigHelper.childElements(child)) {
                userCodeDeploymentConfig.addClass(this.getTextContent(classNameNode));
            }
        } else if (this.matches("jarpaths", childNodeName)) {
            for (Node jarPathNode : DomConfigHelper.childElements(child)) {
                userCodeDeploymentConfig.addJar(this.getTextContent(jarPathNode));
            }
        } else {
            throw new InvalidConfigurationException("User code deployment can either be className or jarPath. " + childNodeName + " is invalid");
        }
    }

    protected void handleNearCache(Node node) {
        this.handleNearCacheNode(node);
    }

    protected void handleNearCacheNode(Node node) {
        String name = this.getName(node);
        name = name == null ? "default" : name;
        NearCacheConfig nearCacheConfig = new NearCacheConfig(name);
        Boolean serializeKeys = null;
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("time-to-live-seconds", nodeName)) {
                nearCacheConfig.setTimeToLiveSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("max-idle-seconds", nodeName)) {
                nearCacheConfig.setMaxIdleSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("in-memory-format", nodeName)) {
                nearCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(this.getTextContent(child))));
                continue;
            }
            if (this.matches("serialize-keys", nodeName)) {
                serializeKeys = Boolean.parseBoolean(this.getTextContent(child));
                nearCacheConfig.setSerializeKeys(serializeKeys);
                continue;
            }
            if (this.matches("invalidate-on-change", nodeName)) {
                nearCacheConfig.setInvalidateOnChange(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("local-update-policy", nodeName)) {
                nearCacheConfig.setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.valueOf(this.getTextContent(child)));
                continue;
            }
            if (this.matches("eviction", nodeName)) {
                nearCacheConfig.setEvictionConfig(this.getEvictionConfig(child));
                continue;
            }
            if (!this.matches("preloader", nodeName)) continue;
            nearCacheConfig.setPreloaderConfig(this.getNearCachePreloaderConfig(child));
        }
        if (serializeKeys != null && !serializeKeys.booleanValue() && nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            LOGGER.warning("The Near Cache doesn't support keys by-reference with NATIVE in-memory-format. This setting will have no effect!");
        }
        this.clientConfig.addNearCacheConfig(nearCacheConfig);
    }

    protected String getName(Node node) {
        return this.getAttribute(node, "name");
    }

    protected void handleFlakeIdGenerator(Node node) {
        this.handleFlakeIdGeneratorNode(node);
    }

    protected void handleFlakeIdGeneratorNode(Node node) {
        String name = this.getName(node);
        ClientFlakeIdGeneratorConfig config = new ClientFlakeIdGeneratorConfig(name);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("prefetch-count", nodeName)) {
                config.setPrefetchCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("prefetch-validity-millis", StringUtil.lowerCaseInternal(nodeName))) continue;
            config.setPrefetchValidityMillis(Long.parseLong(this.getTextContent(child)));
        }
        this.clientConfig.addFlakeIdGeneratorConfig(config);
    }

    protected void handleReliableTopic(Node node) {
        this.handleReliableTopicNode(node);
    }

    protected void handleReliableTopicNode(Node node) {
        String name = this.getName(node);
        ClientReliableTopicConfig config = new ClientReliableTopicConfig(name);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("topic-overload-policy", nodeName)) {
                config.setTopicOverloadPolicy(TopicOverloadPolicy.valueOf(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("read-batch-size", StringUtil.lowerCaseInternal(nodeName))) continue;
            config.setReadBatchSize(Integer.parseInt(this.getTextContent(child)));
        }
        this.clientConfig.addReliableTopicConfig(config);
    }

    private EvictionConfig getEvictionConfig(Node node) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size = this.getNamedItemNode(node, "size");
        Node maxSizePolicy = this.getNamedItemNode(node, "max-size-policy");
        Node evictionPolicy = this.getNamedItemNode(node, "eviction-policy");
        Node comparatorClassName = this.getNamedItemNode(node, "comparator-class-name");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaxSizePolicy(MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        if (comparatorClassName != null) {
            evictionConfig.setComparatorClassName(this.getTextContent(comparatorClassName));
        }
        return evictionConfig;
    }

    private NearCachePreloaderConfig getNearCachePreloaderConfig(Node node) {
        NearCachePreloaderConfig preloaderConfig = new NearCachePreloaderConfig();
        String enabled = this.getAttribute(node, "enabled");
        String directory = this.getAttribute(node, "directory");
        String storeInitialDelaySeconds = this.getAttribute(node, "store-initial-delay-seconds");
        String storeIntervalSeconds = this.getAttribute(node, "store-interval-seconds");
        if (enabled != null) {
            preloaderConfig.setEnabled(DomConfigHelper.getBooleanValue(enabled));
        }
        if (directory != null) {
            preloaderConfig.setDirectory(directory);
        }
        if (storeInitialDelaySeconds != null) {
            preloaderConfig.setStoreInitialDelaySeconds(DomConfigHelper.getIntegerValue("storage-initial-delay-seconds", storeInitialDelaySeconds));
        }
        if (storeIntervalSeconds != null) {
            preloaderConfig.setStoreIntervalSeconds(DomConfigHelper.getIntegerValue("storage-interval-seconds", storeIntervalSeconds));
        }
        return preloaderConfig;
    }

    private void handleLoadBalancer(Node node) {
        String type = this.getAttribute(node, "type");
        if (this.matches("random", type)) {
            this.clientConfig.setLoadBalancer(new RandomLB());
        } else if (this.matches("round-robin", type)) {
            this.clientConfig.setLoadBalancer(new RoundRobinLB());
        } else if ("custom".equals(type)) {
            String loadBalancerClassName = this.parseCustomLoadBalancerClassName(node);
            this.clientConfig.setLoadBalancerClassName(loadBalancerClassName);
        }
    }

    protected String parseCustomLoadBalancerClassName(Node node) {
        return this.getTextContent(node);
    }

    private void handleNetwork(Node node) {
        ClientNetworkConfig clientNetworkConfig = new ClientNetworkConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("cluster-members", nodeName)) {
                this.handleClusterMembers(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("smart-routing", nodeName)) {
                this.handleLegacySmartRouting(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("cluster-routing", nodeName)) {
                this.handleClusterRouting(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("redo-operation", nodeName)) {
                clientNetworkConfig.setRedoOperation(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("connection-timeout", nodeName)) {
                clientNetworkConfig.setConnectionTimeout(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("socket-options", nodeName)) {
                this.handleSocketOptions(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("socket-interceptor", nodeName)) {
                this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("ssl", nodeName)) {
                this.handleSSLConfig(child, clientNetworkConfig);
                continue;
            }
            if (AliasedDiscoveryConfigUtils.supports(nodeName)) {
                this.handleAliasedDiscoveryStrategy(child, clientNetworkConfig, nodeName);
                continue;
            }
            if (this.matches("discovery-strategies", nodeName)) {
                this.handleDiscoveryStrategies(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("auto-detection", nodeName)) {
                this.handleAutoDetection(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("outbound-ports", nodeName)) {
                this.handleOutboundPorts(child, clientNetworkConfig);
                continue;
            }
            if (this.matches("icmp-ping", nodeName)) {
                this.handleIcmpPing(child, clientNetworkConfig);
                continue;
            }
            if (!this.matches("hazelcast-cloud", nodeName)) continue;
            this.handleHazelcastCloud(child, clientNetworkConfig);
        }
        this.clientConfig.setNetworkConfig(clientNetworkConfig);
    }

    private void checkForAlreadyProcessed() {
        if (this.processedRoutingMode) {
            throw new InvalidConfigurationException("\"smart-routing\" should not be present in configuration when \"cluster-routing\" is present - only \"cluster-routing\" should be used.\n");
        }
    }

    private void handleLegacySmartRouting(Node child, ClientNetworkConfig clientNetworkConfig) {
        this.checkForAlreadyProcessed();
        boolean enabled = Boolean.parseBoolean(this.getTextContent(child));
        clientNetworkConfig.getClusterRoutingConfig().setRoutingMode(enabled ? RoutingMode.ALL_MEMBERS : RoutingMode.SINGLE_MEMBER);
        this.processedRoutingMode = true;
    }

    private void handleClusterRouting(Node child, ClientNetworkConfig clientNetworkConfig) {
        RoutingStrategy routingStrategy;
        RoutingMode routingMode;
        this.checkForAlreadyProcessed();
        String mode = this.getAttribute(child, "mode");
        try {
            routingMode = RoutingMode.valueOf(mode);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Invalid RoutingMode '" + mode + "' defined.", e);
        }
        String attribute = this.getAttribute(child, "routing-strategy");
        try {
            routingStrategy = attribute == null ? ClusterRoutingConfig.DEFAULT_ROUTING_STRATEGY : RoutingStrategy.valueOf(attribute);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Invalid RoutingStrategy '" + attribute + "' defined.", e);
        }
        ClusterRoutingConfig clusterRoutingConfig = clientNetworkConfig.getClusterRoutingConfig();
        clusterRoutingConfig.setRoutingMode(routingMode);
        clusterRoutingConfig.setRoutingStrategy(routingStrategy);
        this.processedRoutingMode = true;
    }

    private void handleHazelcastCloud(Node node, ClientNetworkConfig clientNetworkConfig) {
        ClientCloudConfig cloudConfig = clientNetworkConfig.getCloudConfig();
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        cloudConfig.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("discovery-token", nodeName)) continue;
            cloudConfig.setDiscoveryToken(this.getTextContent(child));
        }
    }

    private void handleIcmpPing(Node node, ClientNetworkConfig clientNetworkConfig) {
        ClientIcmpPingConfig icmpPingConfig = clientNetworkConfig.getClientIcmpPingConfig();
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        icmpPingConfig.setEnabled(enabled);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("timeout-milliseconds", nodeName)) {
                icmpPingConfig.setTimeoutMilliseconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("interval-milliseconds", nodeName)) {
                icmpPingConfig.setIntervalMilliseconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("ttl", nodeName)) {
                icmpPingConfig.setTtl(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (this.matches("max-attempts", nodeName)) {
                icmpPingConfig.setMaxAttempts(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("echo-fail-fast-on-startup", nodeName)) continue;
            icmpPingConfig.setEchoFailFastOnStartup(Boolean.parseBoolean(this.getTextContent(child)));
        }
        clientNetworkConfig.setClientIcmpPingConfig(icmpPingConfig);
    }

    protected void handleDiscoveryStrategies(Node node, ClientNetworkConfig clientNetworkConfig) {
        DiscoveryConfig discoveryConfig = clientNetworkConfig.getDiscoveryConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("discovery-strategy", name)) {
                this.handleDiscoveryStrategy(child, discoveryConfig);
                continue;
            }
            if (!this.matches("node-filter", name)) continue;
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    protected void handleAutoDetection(Node node, ClientNetworkConfig clientNetworkConfig) {
        AutoDetectionConfig discoveryConfig = clientNetworkConfig.getAutoDetectionConfig();
        NamedNodeMap atts = node.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node att = atts.item(i);
            if (!this.matches("enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) continue;
            discoveryConfig.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
        }
    }

    protected void handleDiscoveryNodeFilter(Node node, DiscoveryConfig discoveryConfig) {
        Node att = this.getNamedItemNode(node, "class");
        if (att != null) {
            discoveryConfig.setNodeFilterClass(this.getTextContent(att).trim());
        }
    }

    protected void handleDiscoveryStrategy(Node node, DiscoveryConfig discoveryConfig) {
        NamedNodeMap atts = node.getAttributes();
        boolean enabled = false;
        String clazz = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            if (this.matches("enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) {
                enabled = DomConfigHelper.getBooleanValue(this.getTextContent(att));
                continue;
            }
            if (!this.matches("class", att.getNodeName())) continue;
            clazz = this.getTextContent(att);
        }
        if (!enabled || clazz == null) {
            return;
        }
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("properties", name)) continue;
            this.fillProperties(child, properties);
        }
        discoveryConfig.addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(clazz, properties));
    }

    private void handleAliasedDiscoveryStrategy(Node node, ClientNetworkConfig clientNetworkConfig, String tag) {
        AliasedDiscoveryConfig config = ClientAliasedDiscoveryConfigUtils.getConfigByTag(clientNetworkConfig, tag);
        NamedNodeMap atts = node.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node att = atts.item(i);
            if (this.matches("enabled", StringUtil.lowerCaseInternal(att.getNodeName()))) {
                config.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
                continue;
            }
            if (!this.matches(att.getNodeName(), "connection-timeout-seconds")) continue;
            config.setProperty("connection-timeout-seconds", this.getTextContent(att));
        }
        for (Node n : DomConfigHelper.childElements(node)) {
            String key = n.getLocalName();
            String value = this.getTextContent(n);
            config.setProperty(key, value);
        }
    }

    private void handleSSLConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SSLConfig sslConfig = new SSLConfig();
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        boolean enabled = enabledNode != null && DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode).trim());
        sslConfig.setEnabled(enabled);
        for (Node n : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (this.matches("factory-class-name", nodeName)) {
                sslConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(n, sslConfig.getProperties());
        }
        clientNetworkConfig.setSSLConfig(sslConfig);
    }

    private void handleSocketOptions(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketOptions socketOptions = this.clientConfig.getNetworkConfig().getSocketOptions();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("tcp-no-delay", nodeName)) {
                socketOptions.setTcpNoDelay(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("keep-alive", nodeName)) {
                socketOptions.setKeepAlive(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("reuse-address", nodeName)) {
                socketOptions.setReuseAddress(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if (this.matches("linger-seconds", nodeName)) {
                socketOptions.setLingerSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!this.matches("buffer-size", nodeName)) continue;
            socketOptions.setBufferSize(Integer.parseInt(this.getTextContent(child)));
        }
        clientNetworkConfig.setSocketOptions(socketOptions);
    }

    protected void handleClusterMembers(Node node, ClientNetworkConfig clientNetworkConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches("address", DomConfigHelper.cleanNodeName(child))) continue;
            clientNetworkConfig.addAddress(this.getTextContent(child));
        }
    }

    protected void handleListeners(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches("listener", DomConfigHelper.cleanNodeName(child))) continue;
            String className = this.getTextContent(child);
            this.clientConfig.addListenerConfig(new ListenerConfig(className));
        }
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.parseSerialization(node);
        this.clientConfig.setSerializationConfig(serializationConfig);
    }

    private void handleProxyFactories(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleProxyFactoryNode(child);
        }
    }

    protected void handleProxyFactoryNode(Node child) {
        String nodeName = DomConfigHelper.cleanNodeName(child);
        if (this.matches("proxy-factory", nodeName)) {
            this.handleProxyFactory(child);
        }
    }

    protected void handleProxyFactory(Node node) {
        String service = this.getAttribute(node, "service");
        String className = this.getAttribute(node, "class-name");
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig(className, service);
        this.clientConfig.addProxyFactoryConfig(proxyFactoryConfig);
    }

    private void handleSocketInterceptorConfig(Node node, ClientNetworkConfig clientNetworkConfig) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        clientNetworkConfig.setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleSecurity(Node node) {
        ClientSecurityConfig clientSecurityConfig = new ClientSecurityConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("username-password", nodeName)) {
                clientSecurityConfig.setUsernamePasswordIdentityConfig(this.getAttribute(child, "username"), this.getAttribute(child, "password"));
                continue;
            }
            if (this.matches("token", nodeName)) {
                this.handleTokenIdentity(clientSecurityConfig, child);
                continue;
            }
            if (this.matches("credentials-factory", nodeName)) {
                this.handleCredentialsFactory(child, clientSecurityConfig);
                continue;
            }
            if (this.matches("kerberos", nodeName)) {
                this.handleKerberosIdentity(child, clientSecurityConfig);
                continue;
            }
            if (!this.matches("realms", nodeName)) continue;
            this.handleRealms(child, clientSecurityConfig);
        }
        this.clientConfig.setSecurityConfig(clientSecurityConfig);
    }

    protected void handleTokenIdentity(ClientSecurityConfig clientSecurityConfig, Node node) {
        clientSecurityConfig.setTokenIdentityConfig(new TokenIdentityConfig(TokenEncoding.getTokenEncoding(this.getAttribute(node, "encoding")), this.getTextContent(node)));
    }

    private void handleKerberosIdentity(Node node, ClientSecurityConfig clientSecurityConfig) {
        KerberosIdentityConfig kerbIdentity = new KerberosIdentityConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("realm", nodeName)) {
                kerbIdentity.setRealm(this.getTextContent(child));
                continue;
            }
            if (this.matches("security-realm", nodeName)) {
                kerbIdentity.setSecurityRealm(this.getTextContent(child));
                continue;
            }
            if (this.matches("principal", nodeName)) {
                kerbIdentity.setPrincipal(this.getTextContent(child));
                continue;
            }
            if (this.matches("keytab-file", nodeName)) {
                kerbIdentity.setKeytabFile(this.getTextContent(child));
                continue;
            }
            if (this.matches("service-name-prefix", nodeName)) {
                kerbIdentity.setServiceNamePrefix(this.getTextContent(child));
                continue;
            }
            if (this.matches("spn", nodeName)) {
                kerbIdentity.setSpn(this.getTextContent(child));
                continue;
            }
            if (!this.matches("use-canonical-hostname", nodeName)) continue;
            kerbIdentity.setUseCanonicalHostname(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
        }
        clientSecurityConfig.setKerberosIdentityConfig(kerbIdentity);
    }

    protected void handleRealms(Node node, ClientSecurityConfig clientSecurityConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!this.matches("realm", DomConfigHelper.cleanNodeName(child))) continue;
            this.handleRealm(child, clientSecurityConfig);
        }
    }

    protected void handleRealm(Node node, ClientSecurityConfig clientSecurityConfig) {
        String realmName = this.getAttribute(node, "name");
        RealmConfig realmConfig = new RealmConfig();
        clientSecurityConfig.addRealmConfig(realmName, realmConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("authentication", nodeName)) continue;
            this.handleAuthentication(realmConfig, child);
        }
    }

    private void handleAuthentication(RealmConfig realmConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("jaas", nodeName)) continue;
            this.handleJaasAuthentication(realmConfig, child);
        }
    }

    private void handleCredentialsFactory(Node node, ClientSecurityConfig clientSecurityConfig) {
        Node classNameNode = this.getNamedItemNode(node, "class-name");
        String className = this.getTextContent(classNameNode);
        CredentialsFactoryConfig credentialsFactoryConfig = new CredentialsFactoryConfig(className);
        clientSecurityConfig.setCredentialsFactoryConfig(credentialsFactoryConfig);
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("properties", nodeName)) continue;
            this.fillProperties(child, credentialsFactoryConfig.getProperties());
            break;
        }
    }

    protected void handleOutboundPorts(Node child, ClientNetworkConfig clientNetworkConfig) {
        for (Node n : DomConfigHelper.childElements(child)) {
            String nodeName = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("ports", nodeName)) continue;
            clientNetworkConfig.addOutboundPortDefinition(this.getTextContent(n));
        }
    }

    private void handleMetrics(Node node) {
        ClientMetricsConfig metricsConfig = this.clientConfig.getMetricsConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", att.getNodeName())) continue;
            boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
            metricsConfig.setEnabled(enabled);
        }
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("jmx", nodeName)) {
                this.handleMetricsJmx(child);
                continue;
            }
            if (!this.matches("collection-frequency-seconds", nodeName)) continue;
            metricsConfig.setCollectionFrequencySeconds(Integer.parseInt(this.getTextContent(child)));
        }
    }

    private void handleMetricsJmx(Node node) {
        MetricsJmxConfig jmxConfig = this.clientConfig.getMetricsConfig().getJmxConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!this.matches("enabled", att.getNodeName())) continue;
            boolean enabled = DomConfigHelper.getBooleanValue(this.getAttribute(node, "enabled"));
            jmxConfig.setEnabled(enabled);
        }
    }

    private void handleSql(Node node, ClientSqlConfig sqlConfig) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(n);
            if (!this.matches("resubmission-mode", name)) continue;
            sqlConfig.setResubmissionMode(ClientSqlResubmissionMode.valueOf(this.getTextContent(n)));
        }
    }

    private void handleTpc(Node node, ClientTpcConfig tpcConfig) {
        Node enabledNode = this.getNamedItemNode(node, "enabled");
        tpcConfig.setEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(enabledNode)));
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("connection-count", nodeName)) continue;
            tpcConfig.setConnectionCount(Integer.parseInt(this.getTextContent(child)));
        }
    }
}

