/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.journal;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class InternalEventJournalCacheEvent
implements IdentifiedDataSerializable {
    protected Data dataKey;
    protected Data dataNewValue;
    protected Data dataOldValue;
    protected int eventType;

    public InternalEventJournalCacheEvent() {
    }

    public InternalEventJournalCacheEvent(Data dataKey, Data dataNewValue, Data dataOldValue, int eventType) {
        this.eventType = eventType;
        this.dataKey = dataKey;
        this.dataNewValue = dataNewValue;
        this.dataOldValue = dataOldValue;
    }

    public Data getDataKey() {
        return this.dataKey;
    }

    public Data getDataNewValue() {
        return this.dataNewValue;
    }

    public Data getDataOldValue() {
        return this.dataOldValue;
    }

    public int getEventType() {
        return this.eventType;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 55;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.eventType);
        IOUtil.writeData(out, this.dataKey);
        IOUtil.writeData(out, this.dataNewValue);
        IOUtil.writeData(out, this.dataOldValue);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.eventType = in.readInt();
        this.dataKey = IOUtil.readData(in);
        this.dataNewValue = IOUtil.readData(in);
        this.dataOldValue = IOUtil.readData(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalEventJournalCacheEvent that = (InternalEventJournalCacheEvent)o;
        if (this.eventType != that.eventType) {
            return false;
        }
        if (!Objects.equals(this.dataKey, that.dataKey)) {
            return false;
        }
        if (!Objects.equals(this.dataNewValue, that.dataNewValue)) {
            return false;
        }
        return Objects.equals(this.dataOldValue, that.dataOldValue);
    }

    public int hashCode() {
        int result = this.dataKey != null ? this.dataKey.hashCode() : 0;
        result = 31 * result + (this.dataNewValue != null ? this.dataNewValue.hashCode() : 0);
        result = 31 * result + (this.dataOldValue != null ? this.dataOldValue.hashCode() : 0);
        result = 31 * result + this.eventType;
        return result;
    }

    public String toString() {
        return "InternalEventJournalCacheEvent{eventType=" + this.eventType + "}";
    }
}

