/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEntryCountResolver;
import com.hazelcast.cache.impl.CacheEntryListenerProvider;
import com.hazelcast.cache.impl.CacheEventContext;
import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheMXBeanImpl;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePartitionEventData;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.CacheSplitBrainHandlerService;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.CacheStatisticsMXBeanImpl;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.MXBeanUtil;
import com.hazelcast.cache.impl.PreJoinCacheConfig;
import com.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.hazelcast.cache.impl.eviction.CacheClearExpiredRecordsTask;
import com.hazelcast.cache.impl.journal.CacheEventJournal;
import com.hazelcast.cache.impl.journal.RingbufferCacheEventJournalImpl;
import com.hazelcast.cache.impl.operation.AddCacheConfigOperationSupplier;
import com.hazelcast.cache.impl.operation.OnJoinCacheOperation;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheConfigAccessor;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.cluster.ClusterStateListener;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.eviction.ExpirationManager;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.LocalCacheStats;
import com.hazelcast.internal.monitor.impl.LocalCacheStatsImpl;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartitionLostEvent;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionAwareService;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.PreJoinAwareService;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.TenantContextAwareService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.wan.impl.WanReplicationService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryListener;

public abstract class AbstractCacheService
implements ICacheService,
PreJoinAwareService<OnJoinCacheOperation>,
PartitionAwareService,
SplitBrainProtectionAwareService,
SplitBrainHandlerService,
ClusterStateListener,
TenantContextAwareService {
    protected final ConcurrentMap<String, CompletableFuture<CacheConfig>> configs = new ConcurrentHashMap<String, CompletableFuture<CacheConfig>>();
    protected final ConcurrentMap<String, CacheContext> cacheContexts = new ConcurrentHashMap<String, CacheContext>();
    protected final ConcurrentMap<String, CacheStatisticsImpl> statistics = new ConcurrentHashMap<String, CacheStatisticsImpl>();
    protected final ConcurrentMap<String, Set<Closeable>> resources = new ConcurrentHashMap<String, Set<Closeable>>();
    protected final ConcurrentMap<UUID, Closeable> closeableListeners = new ConcurrentHashMap<UUID, Closeable>();
    protected final ConcurrentMap<String, CacheOperationProvider> operationProviderCache = new ConcurrentHashMap<String, CacheOperationProvider>();
    protected final ConstructorFunction<String, CacheContext> cacheContextsConstructorFunction = name -> new CacheContext();
    protected final ConstructorFunction<String, CacheStatisticsImpl> cacheStatisticsConstructorFunction = name -> new CacheStatisticsImpl(Clock.currentTimeMillis(), CacheEntryCountResolver.createEntryCountResolver(this.getOrCreateCacheContext((String)name)));
    protected final ConstructorFunction<String, Set<Closeable>> cacheResourcesConstructorFunction = name -> ConcurrentHashMap.newKeySet();
    protected final ContextMutexFactory cacheResourcesMutexFactory = new ContextMutexFactory();
    protected ILogger logger;
    protected NodeEngine nodeEngine;
    protected CachePartitionSegment[] segments;
    protected CacheEventHandler cacheEventHandler;
    protected RingbufferCacheEventJournalImpl eventJournal;
    protected SplitBrainMergePolicyProvider mergePolicyProvider;
    protected CacheSplitBrainHandlerService splitBrainHandlerService;
    protected CacheClearExpiredRecordsTask clearExpiredRecordsTask;
    protected ExpirationManager expirationManager;

    @Override
    public final void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.segments = new CachePartitionSegment[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.segments[i] = this.newPartitionSegment(i);
        }
        this.clearExpiredRecordsTask = new CacheClearExpiredRecordsTask(this.segments, nodeEngine);
        this.expirationManager = new ExpirationManager(this.clearExpiredRecordsTask, nodeEngine);
        this.cacheEventHandler = new CacheEventHandler(nodeEngine);
        this.splitBrainHandlerService = new CacheSplitBrainHandlerService(nodeEngine, this.segments);
        this.logger = nodeEngine.getLogger(this.getClass());
        this.eventJournal = new RingbufferCacheEventJournalImpl(nodeEngine);
        this.mergePolicyProvider = nodeEngine.getSplitBrainMergePolicyProvider();
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        this.postInit(nodeEngine, properties, dsMetricsEnabled);
    }

    public SplitBrainMergePolicyProvider getMergePolicyProvider() {
        return this.mergePolicyProvider;
    }

    public SplitBrainMergePolicy getMergePolicy(String dataStructureName) {
        CacheConfig cacheConfig = this.getCacheConfig(dataStructureName);
        String mergePolicyName = cacheConfig.getMergePolicyConfig().getPolicy();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyName, cacheConfig.getUserCodeNamespace());
    }

    public ConcurrentMap<String, CacheConfig> getConfigs() {
        ConcurrentMap<String, CacheConfig> cacheConfigs = MapUtil.createConcurrentHashMap(this.configs.size());
        for (Map.Entry config : this.configs.entrySet()) {
            cacheConfigs.put((String)config.getKey(), (CacheConfig)((CompletableFuture)config.getValue()).join());
        }
        return cacheConfigs;
    }

    protected void postInit(NodeEngine nodeEngine, Properties properties, boolean metricsEnabled) {
        if (metricsEnabled) {
            nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    protected abstract CachePartitionSegment newPartitionSegment(int var1);

    protected abstract ICacheRecordStore createNewRecordStore(String var1, int var2);

    @Override
    public void reset() {
        this.reset(false);
    }

    private void reset(boolean onShutdown) {
        for (String objectName : this.configs.keySet()) {
            this.deleteCache(objectName, null, false);
        }
        CachePartitionSegment[] partitionSegments = this.segments;
        for (CachePartitionSegment partitionSegment : partitionSegments) {
            if (partitionSegment == null) continue;
            if (onShutdown) {
                partitionSegment.shutdown();
                continue;
            }
            partitionSegment.reset();
            partitionSegment.init();
        }
        for (String objectName : this.configs.keySet()) {
            this.sendInvalidationEvent(objectName, null, AbstractCacheRecordStore.SOURCE_NOT_AVAILABLE);
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        if (!terminate) {
            this.expirationManager.onShutdown();
            this.cacheEventHandler.shutdown();
            this.reset(true);
        }
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public CachePartitionSegment[] getPartitionSegments() {
        return this.segments;
    }

    @Override
    public DistributedObject createDistributedObject(String cacheNameWithPrefix, UUID source, boolean local) {
        try {
            CacheConfig cacheConfig = this.getCacheConfig(cacheNameWithPrefix);
            if (cacheConfig == null) {
                String cacheName = cacheNameWithPrefix.substring("/hz/".length());
                cacheConfig = this.findCacheConfig(cacheName);
                if (cacheConfig == null) {
                    throw new CacheNotExistsException("Couldn't find cache config with name " + cacheNameWithPrefix);
                }
                cacheConfig.setManagerPrefix("/hz/");
            }
            ConfigValidator.checkCacheConfig(cacheConfig, this.mergePolicyProvider);
            if (this.putCacheConfigIfAbsent(cacheConfig) == null && !local) {
                this.createCacheConfigOnAllMembers(PreJoinCacheConfig.of(cacheConfig));
            }
            return new CacheProxy(cacheConfig, this.nodeEngine, this);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void destroyDistributedObject(String objectName, boolean local) {
        this.deleteCache(objectName, null, true);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearCachesHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
        this.initPartitionReplica(event.getPartitionId());
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearCachesHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
        this.initPartitionReplica(event.getPartitionId());
    }

    private void clearCachesHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        if (thresholdReplicaIndex == -1) {
            this.clearPartitionReplica(partitionId);
            return;
        }
        CachePartitionSegment segment = this.segments[partitionId];
        segment.clearHavingLesserBackupCountThan(thresholdReplicaIndex);
    }

    private void initPartitionReplica(int partitionId) {
        this.segments[partitionId].init();
    }

    private void clearPartitionReplica(int partitionId) {
        this.segments[partitionId].reset();
    }

    @Override
    public ICacheRecordStore getOrCreateRecordStore(String cacheNameWithPrefix, int partitionId) {
        return this.segments[partitionId].getOrCreateRecordStore(cacheNameWithPrefix);
    }

    @Override
    public ICacheRecordStore getRecordStore(String cacheNameWithPrefix, int partitionId) {
        return this.segments[partitionId].getRecordStore(cacheNameWithPrefix);
    }

    @Override
    public CachePartitionSegment getSegment(int partitionId) {
        return this.segments[partitionId];
    }

    protected void destroySegments(CacheConfig cacheConfig) {
        String name = cacheConfig.getNameWithPrefix();
        for (CachePartitionSegment segment : this.segments) {
            segment.deleteRecordStore(name, true);
        }
    }

    protected void closeSegments(String name) {
        for (CachePartitionSegment segment : this.segments) {
            segment.deleteRecordStore(name, false);
        }
    }

    @Override
    public void deleteCache(String cacheNameWithPrefix, UUID callerUuid, boolean destroy) {
        CacheConfig config = this.deleteCacheConfig(cacheNameWithPrefix);
        if (config == null) {
            return;
        }
        if (destroy) {
            this.cacheEventHandler.destroy(cacheNameWithPrefix, AbstractCacheRecordStore.SOURCE_NOT_AVAILABLE);
            this.destroySegments(config);
        } else {
            this.closeSegments(cacheNameWithPrefix);
        }
        WanReplicationService wanService = this.nodeEngine.getWanReplicationService();
        wanService.removeWanEventCounters("hz:impl:cacheService", cacheNameWithPrefix);
        this.operationProviderCache.remove(cacheNameWithPrefix);
        this.deregisterAllListener(cacheNameWithPrefix);
        this.cacheContexts.remove(cacheNameWithPrefix);
        this.setStatisticsEnabled(config, cacheNameWithPrefix, false);
        this.setManagementEnabled(config, cacheNameWithPrefix, false);
        this.deleteCacheStat(cacheNameWithPrefix);
        this.deleteCacheResources(cacheNameWithPrefix);
    }

    @Override
    public CacheConfig putCacheConfigIfAbsent(CacheConfig config) {
        CacheConfig localConfig;
        CacheConfig cacheConfig = PreJoinCacheConfig.asCacheConfig(config);
        CompletableFuture future = new CompletableFuture();
        CompletableFuture localConfigFuture = this.configs.putIfAbsent(cacheConfig.getNameWithPrefix(), future);
        CacheConfig cacheConfig2 = localConfig = localConfigFuture == null ? null : (CacheConfig)localConfigFuture.join();
        if (localConfigFuture == null) {
            try {
                if (cacheConfig.isStatisticsEnabled()) {
                    this.setStatisticsEnabled(cacheConfig, cacheConfig.getNameWithPrefix(), true);
                }
                if (cacheConfig.isManagementEnabled()) {
                    this.setManagementEnabled(cacheConfig, cacheConfig.getNameWithPrefix(), true);
                }
                this.logger.info("Added cache config: " + String.valueOf(cacheConfig));
                this.additionalCacheConfigSetup(config, false);
                future.complete(cacheConfig);
            }
            catch (Throwable e) {
                this.configs.remove(cacheConfig.getNameWithPrefix(), future);
                future.completeExceptionally(e);
                throw ExceptionUtil.rethrow(e);
            }
        } else {
            this.additionalCacheConfigSetup(localConfig, true);
        }
        return localConfig;
    }

    protected void additionalCacheConfigSetup(CacheConfig config, boolean existingConfig) {
    }

    @Override
    public CacheConfig deleteCacheConfig(String cacheNameWithPrefix) {
        CompletableFuture cacheConfigFuture = (CompletableFuture)this.configs.remove(cacheNameWithPrefix);
        CacheConfig cacheConfig = null;
        if (cacheConfigFuture != null) {
            cacheConfig = (CacheConfig)cacheConfigFuture.join();
            this.logger.info("Removed cache config: " + String.valueOf(cacheConfig));
        }
        return cacheConfig;
    }

    @Override
    public ExpirationManager getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public CacheStatisticsImpl createCacheStatIfAbsent(String cacheNameWithPrefix) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statistics, cacheNameWithPrefix, this.cacheStatisticsConstructorFunction);
    }

    public CacheContext getCacheContext(String name) {
        return (CacheContext)this.cacheContexts.get(name);
    }

    @Override
    public CacheContext getOrCreateCacheContext(String cacheNameWithPrefix) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.cacheContexts, cacheNameWithPrefix, this.cacheContextsConstructorFunction);
    }

    @Override
    public void deleteCacheStat(String cacheNameWithPrefix) {
        this.statistics.remove(cacheNameWithPrefix);
    }

    @Override
    public void setStatisticsEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : this.getCacheConfig(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setStatisticsEnabled(enabled);
            if (enabled) {
                CacheStatisticsImpl cacheStatistics = this.createCacheStatIfAbsent(cacheNameWithPrefix);
                CacheStatisticsMXBeanImpl mxBean = new CacheStatisticsMXBeanImpl(cacheStatistics);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), true);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), true);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public void setManagementEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : this.getCacheConfig(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setManagementEnabled(enabled);
            if (enabled) {
                CacheMXBeanImpl mxBean = new CacheMXBeanImpl(cacheConfig);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), false);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), false);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public CacheConfig getCacheConfig(String cacheNameWithPrefix) {
        CompletableFuture future = (CompletableFuture)this.configs.get(cacheNameWithPrefix);
        return future == null ? null : (CacheConfig)future.join();
    }

    @Override
    public CacheConfig findCacheConfig(String simpleName) {
        if (simpleName == null) {
            return null;
        }
        CacheSimpleConfig cacheSimpleConfig = this.nodeEngine.getConfig().findCacheConfigOrNull(simpleName);
        if (cacheSimpleConfig == null) {
            return null;
        }
        try {
            CacheConfig cacheConfig = new CacheConfig(cacheSimpleConfig).setName(simpleName);
            CacheConfigAccessor.setSerializationService(cacheConfig, this.nodeEngine.getSerializationService());
            return cacheConfig;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public <K, V> CacheConfig<K, V> reSerializeCacheConfig(CacheConfig<K, V> cacheConfig) {
        CacheConfig<K, V> serializedCacheConfig = PreJoinCacheConfig.of(cacheConfig).asCacheConfig();
        CompletableFuture<CacheConfig<K, V>> future = new CompletableFuture<CacheConfig<K, V>>();
        future.complete(serializedCacheConfig);
        this.configs.replace(cacheConfig.getNameWithPrefix(), future);
        return serializedCacheConfig;
    }

    @Override
    public Collection<CacheConfig> getCacheConfigs() {
        ArrayList<CacheConfig> cacheConfigs = new ArrayList<CacheConfig>(this.configs.size());
        for (CompletableFuture future : this.configs.values()) {
            cacheConfigs.add((CacheConfig)future.join());
        }
        return cacheConfigs;
    }

    public Object toObject(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Data) {
            return this.nodeEngine.toObject(data);
        }
        return data;
    }

    public Object toObject(Object data, String namespace) {
        if (data == null) {
            return null;
        }
        if (data instanceof Data) {
            return NamespaceUtil.callWithNamespace(this.nodeEngine, namespace, () -> this.nodeEngine.toObject(data));
        }
        return data;
    }

    public Data toData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Data) {
            Data data = (Data)object;
            return data;
        }
        return this.nodeEngine.getSerializationService().toData(object);
    }

    @Override
    public void publishEvent(CacheEventContext cacheEventContext) {
        this.cacheEventHandler.publishEvent(cacheEventContext);
    }

    @Override
    public void publishEvent(String cacheNameWithPrefix, CacheEventSet eventSet, int orderKey) {
        this.cacheEventHandler.publishEvent(cacheNameWithPrefix, eventSet, orderKey);
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void dispatchEvent(Object event, CacheEventListener listener) {
        listener.handleEvent(event);
    }

    @Override
    public UUID registerLocalListener(String cacheNameWithPrefix, CacheEventListener listener) {
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:impl:cacheService", cacheNameWithPrefix, listener);
        if (registration == null) {
            return null;
        }
        return this.updateRegisteredListeners(listener, registration);
    }

    @Override
    public UUID registerLocalListener(String cacheNameWithPrefix, CacheEventListener listener, EventFilter eventFilter) {
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:impl:cacheService", cacheNameWithPrefix, eventFilter, listener);
        if (registration == null) {
            return null;
        }
        return this.updateRegisteredListeners(listener, registration);
    }

    @Override
    public CompletableFuture<UUID> registerListenerAsync(String cacheNameWithPrefix, CacheEventListener listener) {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.registerListenerAsync("hz:impl:cacheService", cacheNameWithPrefix, listener).thenApplyAsync(eventRegistration -> this.updateRegisteredListeners(listener, (EventRegistration)eventRegistration), ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public CompletableFuture<UUID> registerListenerAsync(String cacheNameWithPrefix, CacheEventListener listener, EventFilter eventFilter) {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.registerListenerAsync("hz:impl:cacheService", cacheNameWithPrefix, eventFilter, listener).thenApplyAsync(eventRegistration -> this.updateRegisteredListeners(listener, (EventRegistration)eventRegistration), ConcurrencyUtil.CALLER_RUNS);
    }

    private UUID updateRegisteredListeners(CacheEventListener listener, EventRegistration eventRegistration) {
        CacheEntryListenerProvider provider;
        CacheEntryListener cacheEntryListener;
        UUID id = eventRegistration.getId();
        if (listener instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)listener);
            this.closeableListeners.put(id, closeable);
        } else if (listener instanceof CacheEntryListenerProvider && (cacheEntryListener = (provider = (CacheEntryListenerProvider)((Object)listener)).getCacheEntryListener()) instanceof Closeable) {
            Closeable closeable = (Closeable)cacheEntryListener;
            this.closeableListeners.put(id, closeable);
        }
        return id;
    }

    @Override
    public UUID registerListener(String cacheNameWithPrefix, CacheEventListener listener) {
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventService.registerListener("hz:impl:cacheService", cacheNameWithPrefix, listener);
        return this.updateRegisteredListeners(listener, registration);
    }

    @Override
    public UUID registerListener(String cacheNameWithPrefix, CacheEventListener listener, EventFilter eventFilter) {
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventService.registerListener("hz:impl:cacheService", cacheNameWithPrefix, eventFilter, listener);
        return this.updateRegisteredListeners(listener, registration);
    }

    @Override
    public CompletableFuture<Boolean> deregisterListenerAsync(String cacheNameWithPrefix, UUID registrationId) {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.deregisterListenerAsync("hz:impl:cacheService", cacheNameWithPrefix, registrationId).thenApplyAsync(result -> {
            this.removeFromLocalResources(registrationId);
            return result;
        }, ConcurrencyUtil.CALLER_RUNS);
    }

    private void removeFromLocalResources(UUID registrationId) {
        Closeable listener = (Closeable)this.closeableListeners.remove(registrationId);
        if (listener != null) {
            IOUtil.closeResource(listener);
        }
    }

    @Override
    public boolean deregisterListener(String cacheNameWithPrefix, UUID registrationId) {
        EventService eventService = this.getNodeEngine().getEventService();
        if (eventService.deregisterListener("hz:impl:cacheService", cacheNameWithPrefix, registrationId)) {
            this.removeFromLocalResources(registrationId);
            return true;
        }
        return false;
    }

    @Override
    public void deregisterAllListener(String cacheNameWithPrefix) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", cacheNameWithPrefix);
        if (registrations != null) {
            for (EventRegistration registration : registrations) {
                this.removeFromLocalResources(registration.getId());
            }
        }
        eventService.deregisterAllLocalListeners("hz:impl:cacheService", cacheNameWithPrefix);
        CacheContext cacheContext = (CacheContext)this.cacheContexts.get(cacheNameWithPrefix);
        if (cacheContext != null) {
            cacheContext.resetCacheEntryListenerCount();
            cacheContext.resetInvalidationListenerCount();
        }
    }

    @Override
    public Map<String, LocalCacheStats> getStats() {
        Map<String, LocalCacheStats> stats = MapUtil.createHashMap(this.statistics.size());
        for (Map.Entry entry : this.statistics.entrySet()) {
            stats.put((String)entry.getKey(), new LocalCacheStatsImpl((CacheStatistics)entry.getValue()));
        }
        return stats;
    }

    @Override
    public CacheOperationProvider getCacheOperationProvider(String cacheNameWithPrefix, InMemoryFormat inMemoryFormat) {
        if (InMemoryFormat.NATIVE == inMemoryFormat) {
            throw new IllegalArgumentException("Native memory is available only in Hazelcast Enterprise.Make sure you have Hazelcast Enterprise JARs on your classpath!");
        }
        CacheOperationProvider cacheOperationProvider = (CacheOperationProvider)this.operationProviderCache.get(cacheNameWithPrefix);
        if (cacheOperationProvider != null) {
            return cacheOperationProvider;
        }
        cacheOperationProvider = this.createOperationProvider(cacheNameWithPrefix, inMemoryFormat);
        CacheOperationProvider current = this.operationProviderCache.putIfAbsent(cacheNameWithPrefix, cacheOperationProvider);
        return current == null ? cacheOperationProvider : current;
    }

    protected abstract CacheOperationProvider createOperationProvider(String var1, InMemoryFormat var2);

    public void addCacheResource(String cacheNameWithPrefix, Closeable resource) {
        Set<Closeable> cacheResources = ConcurrencyUtil.getOrPutSynchronized(this.resources, cacheNameWithPrefix, this.cacheResourcesMutexFactory, this.cacheResourcesConstructorFunction);
        cacheResources.add(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCacheResources(String name) {
        Set cacheResources;
        try (ContextMutexFactory.Mutex mutex = this.cacheResourcesMutexFactory.mutexFor(name);){
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                cacheResources = (Set)this.resources.remove(name);
            }
        }
        if (cacheResources != null) {
            for (Closeable resource : cacheResources) {
                IOUtil.closeResource(resource);
            }
            cacheResources.clear();
        }
    }

    @Override
    public OnJoinCacheOperation getPreJoinOperation() {
        OnJoinCacheOperation preJoinCacheOperation = new OnJoinCacheOperation();
        for (Map.Entry cacheConfigEntry : this.configs.entrySet()) {
            PreJoinCacheConfig cacheConfig = new PreJoinCacheConfig((CacheConfig)((CompletableFuture)cacheConfigEntry.getValue()).join(), false);
            preJoinCacheOperation.addCacheConfig(cacheConfig);
        }
        return preJoinCacheOperation;
    }

    protected void publishCachePartitionLostEvent(String cacheName, int partitionId) {
        LinkedList<EventRegistration> registrations = new LinkedList<EventRegistration>();
        for (EventRegistration registration : this.getRegistrations(cacheName)) {
            if (!(registration.getFilter() instanceof CachePartitionLostEventFilter)) continue;
            registrations.add(registration);
        }
        if (registrations.isEmpty()) {
            return;
        }
        Member member = this.nodeEngine.getLocalMember();
        CachePartitionEventData eventData = new CachePartitionEventData(cacheName, partitionId, member);
        EventService eventService = this.nodeEngine.getEventService();
        eventService.publishEvent("hz:impl:cacheService", registrations, (Object)eventData, partitionId);
    }

    Collection<EventRegistration> getRegistrations(String cacheName) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.getRegistrations("hz:impl:cacheService", cacheName);
    }

    @Override
    public void onPartitionLost(IPartitionLostEvent partitionLostEvent) {
        int partitionId = partitionLostEvent.getPartitionId();
        for (CacheConfig config : this.getCacheConfigs()) {
            String cacheName = config.getName();
            if (config.getTotalBackupCount() > partitionLostEvent.getLostReplicaIndex()) continue;
            this.publishCachePartitionLostEvent(cacheName, partitionId);
        }
    }

    public void cacheEntryListenerRegistered(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration) {
        CacheConfig cacheConfig = this.getCacheConfig(name);
        if (cacheConfig == null) {
            throw new IllegalStateException("CacheConfig does not exist for cache " + name);
        }
        cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public void cacheEntryListenerDeregistered(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration) {
        CacheConfig cacheConfig = this.getCacheConfig(name);
        if (cacheConfig == null) {
            throw new IllegalStateException("CacheConfig does not exist for cache " + name);
        }
        cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    @Override
    public String getSplitBrainProtectionName(String cacheName) {
        CacheConfig cacheConfig = this.getCacheConfig(cacheName);
        if (cacheConfig == null) {
            return null;
        }
        return cacheConfig.getSplitBrainProtectionName();
    }

    @Override
    public void sendInvalidationEvent(String cacheNameWithPrefix, Data key, UUID sourceUuid) {
        this.cacheEventHandler.sendInvalidationEvent(cacheNameWithPrefix, key, sourceUuid);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.splitBrainHandlerService.prepareMergeRunnable();
    }

    public CacheEventHandler getCacheEventHandler() {
        return this.cacheEventHandler;
    }

    @Override
    public CacheEventJournal getEventJournal() {
        return this.eventJournal;
    }

    @Override
    public <K, V> void createCacheConfigOnAllMembers(PreJoinCacheConfig<K, V> cacheConfig) {
        InternalCompletableFuture<Object> future = this.createCacheConfigOnAllMembersAsync(cacheConfig);
        FutureUtil.waitForever(Collections.singleton(future), FutureUtil.RETHROW_EVERYTHING);
    }

    public <K, V> InternalCompletableFuture<Object> createCacheConfigOnAllMembersAsync(PreJoinCacheConfig<K, V> cacheConfig) {
        return InvocationUtil.invokeOnStableClusterSerial(this.getNodeEngine(), new AddCacheConfigOperationSupplier(cacheConfig), 100);
    }

    @Override
    public void onClusterStateChange(ClusterState newState) {
        ExpirationManager expManager = this.expirationManager;
        if (expManager != null) {
            expManager.onClusterStateChange(newState);
        }
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "cache", this.getStats());
    }
}

