/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.jet.core.function;

import com.hazelcast.internal.util.ExceptionUtil;

import java.io.Serializable;

/**
 * Represents a specialization of {@link java.util.function.BiFunction} where
 * the second argument is a {@code long}.
 *
 * @param <T> the type of the first argument to the function
 * @param <R> the type of the result of the function
 *
 * @since Jet 3.0
 */
@FunctionalInterface
public interface ObjLongBiFunction<T, R> extends Serializable {

    /**
     * Exception-declaring version of {@link ObjLongBiFunction#apply}.
     */
    R applyEx(T t, long u) throws Exception;

    /**
     * Applies this function to the given arguments.
     *
     * @param t the first function argument
     * @param u the second function argument
     * @return the function result
     */
    default R apply(T t, long u) {
        try {
            return applyEx(t, u);
        } catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }
}
