/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;

import java.io.IOException;

/**
 * A simple class that holds the status of the replication for a
 * schema.
 */
public final class SchemaReplication implements IdentifiedDataSerializable {

    private Schema schema;
    private volatile SchemaReplicationStatus status;

    public SchemaReplication() {
    }

    public SchemaReplication(Schema schema, SchemaReplicationStatus status) {
        this.schema = schema;
        this.status = status;
    }

    public Schema getSchema() {
        return schema;
    }

    public void setStatus(SchemaReplicationStatus status) {
        this.status = status;
    }

    public SchemaReplicationStatus getStatus() {
        return status;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(schema);
        out.writeInt(status.getId());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        schema = in.readObject();
        status = SchemaReplicationStatus.fromId(in.readInt());
    }

    @Override
    public int getFactoryId() {
        return SchemaDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return SchemaDataSerializerHook.SCHEMA_REPLICATION;
    }

    @Override
    public String toString() {
        return "SchemaReplication [schema=" + schema + ", status=" + status + "]";
    }
}
