/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.client.impl.protocol.codec.holder;

import java.util.Objects;

public final class WanSyncConfigHolder {
    private final byte consistencyCheckStrategy;

    public WanSyncConfigHolder(byte consistencyCheckStrategy) {
        this.consistencyCheckStrategy = consistencyCheckStrategy;
    }

    public byte getConsistencyCheckStrategy() {
        return consistencyCheckStrategy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WanSyncConfigHolder that = (WanSyncConfigHolder) o;
        return consistencyCheckStrategy == that.consistencyCheckStrategy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(consistencyCheckStrategy);
    }
}
