/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.Generated;
import com.hazelcast.client.impl.protocol.codec.builtin.*;
import com.hazelcast.client.impl.protocol.codec.custom.*;

import javax.annotation.Nullable;

import static com.hazelcast.client.impl.protocol.ClientMessage.*;
import static com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec.*;

/*
 * This file is auto-generated by the Hazelcast Client Protocol Code Generator.
 * To change this file, edit the templates or the protocol
 * definitions on the https://github.com/hazelcast/hazelcast-client-protocol
 * and regenerate it.
 */

/**
 * Gets the diagnostics configuration from the member.
 */
@SuppressWarnings("unused")
@Generated("05dd8f7ecb19a3790aed6d410ad98370")
public final class MCGetDiagnosticsConfigCodec {
    //hex: 0x202800
    public static final int REQUEST_MESSAGE_TYPE = 2107392;
    //hex: 0x202801
    public static final int RESPONSE_MESSAGE_TYPE = 2107393;
    private static final int REQUEST_INITIAL_FRAME_SIZE = PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int RESPONSE_ENABLED_FIELD_OFFSET = RESPONSE_BACKUP_ACKS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int RESPONSE_INCLUDE_EPOCH_TIME_FIELD_OFFSET = RESPONSE_ENABLED_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;
    private static final int RESPONSE_MAX_ROLLED_FILE_SIZE_IN_MB_FIELD_OFFSET = RESPONSE_INCLUDE_EPOCH_TIME_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;
    private static final int RESPONSE_MAX_ROLLED_FILE_COUNT_FIELD_OFFSET = RESPONSE_MAX_ROLLED_FILE_SIZE_IN_MB_FIELD_OFFSET + FLOAT_SIZE_IN_BYTES;
    private static final int RESPONSE_AUTO_OFF_DURATION_IN_MINUTES_FIELD_OFFSET = RESPONSE_MAX_ROLLED_FILE_COUNT_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int RESPONSE_CAN_BE_CONFIGURED_DYNAMICALLY_FIELD_OFFSET = RESPONSE_AUTO_OFF_DURATION_IN_MINUTES_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = RESPONSE_CAN_BE_CONFIGURED_DYNAMICALLY_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;

    private MCGetDiagnosticsConfigCodec() {
    }

    public static ClientMessage encodeRequest() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MC.GetDiagnosticsConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[REQUEST_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, REQUEST_MESSAGE_TYPE);
        encodeInt(initialFrame.content, PARTITION_ID_FIELD_OFFSET, -1);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class ResponseParameters {

        /**
         * Indicates whether diagnostics service is enabled or not
         */
        public boolean enabled;

        /**
         * The output type for the diagnostics
         */
        public java.lang.String outputType;

        /**
         * Indicates if the epoch time should be included in the 'top' section
         */
        public boolean includeEpochTime;

        /**
         * The maximum size in MB for a single file
         */
        public float maxRolledFileSizeInMB;

        /**
         * The maximum number of rolling files to keep on disk
         */
        public int maxRolledFileCount;

        /**
         * The path of output directory for the diagnostics log files. It can be a relative path to the working directory or an absolute path
         */
        public java.lang.String logDirectory;

        /**
         * The prefix for the diagnostics file
         */
        public @Nullable java.lang.String fileNamePrefix;

        /**
         * Properties specific to DiagnosticsPlugin implementations
         */
        public @Nullable java.util.Map<java.lang.String, java.lang.String> properties;

        /**
         * The auto time off duration for the service in minutes. The value must be positive. Set -1 only if you want to disable the auto time off feature.
         */
        public int autoOffDurationInMinutes;

        /**
         * Indicates whether the diagnostics service can be configured dynamically or not
         */
        public boolean canBeConfiguredDynamically;
    }

    public static ClientMessage encodeResponse(boolean enabled, java.lang.String outputType, boolean includeEpochTime, float maxRolledFileSizeInMB, int maxRolledFileCount, java.lang.String logDirectory, @Nullable java.lang.String fileNamePrefix, @Nullable java.util.Map<java.lang.String, java.lang.String> properties, int autoOffDurationInMinutes, boolean canBeConfiguredDynamically) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[RESPONSE_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, RESPONSE_MESSAGE_TYPE);
        encodeBoolean(initialFrame.content, RESPONSE_ENABLED_FIELD_OFFSET, enabled);
        encodeBoolean(initialFrame.content, RESPONSE_INCLUDE_EPOCH_TIME_FIELD_OFFSET, includeEpochTime);
        encodeFloat(initialFrame.content, RESPONSE_MAX_ROLLED_FILE_SIZE_IN_MB_FIELD_OFFSET, maxRolledFileSizeInMB);
        encodeInt(initialFrame.content, RESPONSE_MAX_ROLLED_FILE_COUNT_FIELD_OFFSET, maxRolledFileCount);
        encodeInt(initialFrame.content, RESPONSE_AUTO_OFF_DURATION_IN_MINUTES_FIELD_OFFSET, autoOffDurationInMinutes);
        encodeBoolean(initialFrame.content, RESPONSE_CAN_BE_CONFIGURED_DYNAMICALLY_FIELD_OFFSET, canBeConfiguredDynamically);
        clientMessage.add(initialFrame);

        StringCodec.encode(clientMessage, outputType);
        StringCodec.encode(clientMessage, logDirectory);
        CodecUtil.encodeNullable(clientMessage, fileNamePrefix, StringCodec::encode);
        MapCodec.encodeNullable(clientMessage, properties, StringCodec::encode, StringCodec::encode);
        return clientMessage;
    }

    public static MCGetDiagnosticsConfigCodec.ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.enabled = decodeBoolean(initialFrame.content, RESPONSE_ENABLED_FIELD_OFFSET);
        response.includeEpochTime = decodeBoolean(initialFrame.content, RESPONSE_INCLUDE_EPOCH_TIME_FIELD_OFFSET);
        response.maxRolledFileSizeInMB = decodeFloat(initialFrame.content, RESPONSE_MAX_ROLLED_FILE_SIZE_IN_MB_FIELD_OFFSET);
        response.maxRolledFileCount = decodeInt(initialFrame.content, RESPONSE_MAX_ROLLED_FILE_COUNT_FIELD_OFFSET);
        response.autoOffDurationInMinutes = decodeInt(initialFrame.content, RESPONSE_AUTO_OFF_DURATION_IN_MINUTES_FIELD_OFFSET);
        response.canBeConfiguredDynamically = decodeBoolean(initialFrame.content, RESPONSE_CAN_BE_CONFIGURED_DYNAMICALLY_FIELD_OFFSET);
        response.outputType = StringCodec.decode(iterator);
        response.logDirectory = StringCodec.decode(iterator);
        response.fileNamePrefix = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        response.properties = MapCodec.decodeNullable(iterator, StringCodec::decode, StringCodec::decode);
        return response;
    }
}
