/*
 * Copyright (c) 2008-2025, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.Generated;
import com.hazelcast.client.impl.protocol.codec.builtin.*;
import com.hazelcast.client.impl.protocol.codec.custom.*;

import javax.annotation.Nullable;

import static com.hazelcast.client.impl.protocol.ClientMessage.*;
import static com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec.*;

/*
 * This file is auto-generated by the Hazelcast Client Protocol Code Generator.
 * To change this file, edit the templates or the protocol
 * definitions on the https://github.com/hazelcast/hazelcast-client-protocol
 * and regenerate it.
 */

/**
 */
@SuppressWarnings("unused")
@Generated("03a037347b2138fe83d6244f7cdb2151")
public final class JetUploadJobMetaDataCodec {
    //hex: 0xFE1100
    public static final int REQUEST_MESSAGE_TYPE = 16650496;
    //hex: 0xFE1101
    public static final int RESPONSE_MESSAGE_TYPE = 16650497;
    private static final int REQUEST_SESSION_ID_FIELD_OFFSET = PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int REQUEST_JAR_ON_MEMBER_FIELD_OFFSET = REQUEST_SESSION_ID_FIELD_OFFSET + UUID_SIZE_IN_BYTES;
    private static final int REQUEST_INITIAL_FRAME_SIZE = REQUEST_JAR_ON_MEMBER_FIELD_OFFSET + BOOLEAN_SIZE_IN_BYTES;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = RESPONSE_BACKUP_ACKS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;

    private JetUploadJobMetaDataCodec() {
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings("URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD")
    public static class RequestParameters {

        /**
         * Unique session ID of the job upload request
         */
        public java.util.UUID sessionId;

        /**
         * Flag that indicates that the jar to be executed is already present on the member, and no jar will be uploaded from the client
         */
        public boolean jarOnMember;

        /**
         * Name of the jar file without extension
         */
        public java.lang.String fileName;

        /**
         * Hexadecimal SHA256 of the jar file
         */
        public java.lang.String sha256Hex;

        /**
         * Name of the initial snapshot to start the job from
         */
        public @Nullable java.lang.String snapshotName;

        /**
         * Name of the job
         */
        public @Nullable java.lang.String jobName;

        /**
         * Fully qualified name of the main class inside the JAR file
         */
        public @Nullable java.lang.String mainClass;

        /**
         * Arguments to pass to the supplied jar file
         */
        public java.util.List<java.lang.String> jobParameters;
    }

    public static ClientMessage encodeRequest(java.util.UUID sessionId, boolean jarOnMember, java.lang.String fileName, java.lang.String sha256Hex, @Nullable java.lang.String snapshotName, @Nullable java.lang.String jobName, @Nullable java.lang.String mainClass, java.util.Collection<java.lang.String> jobParameters) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Jet.UploadJobMetaData");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[REQUEST_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, REQUEST_MESSAGE_TYPE);
        encodeInt(initialFrame.content, PARTITION_ID_FIELD_OFFSET, -1);
        encodeUUID(initialFrame.content, REQUEST_SESSION_ID_FIELD_OFFSET, sessionId);
        encodeBoolean(initialFrame.content, REQUEST_JAR_ON_MEMBER_FIELD_OFFSET, jarOnMember);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, fileName);
        StringCodec.encode(clientMessage, sha256Hex);
        CodecUtil.encodeNullable(clientMessage, snapshotName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, jobName, StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mainClass, StringCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, jobParameters, StringCodec::encode);
        return clientMessage;
    }

    public static JetUploadJobMetaDataCodec.RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.sessionId = decodeUUID(initialFrame.content, REQUEST_SESSION_ID_FIELD_OFFSET);
        request.jarOnMember = decodeBoolean(initialFrame.content, REQUEST_JAR_ON_MEMBER_FIELD_OFFSET);
        request.fileName = StringCodec.decode(iterator);
        request.sha256Hex = StringCodec.decode(iterator);
        request.snapshotName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.jobName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mainClass = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.jobParameters = ListMultiFrameCodec.decode(iterator, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[RESPONSE_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, RESPONSE_MESSAGE_TYPE);
        clientMessage.add(initialFrame);

        return clientMessage;
    }
}
