/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MetadataPolicy;
import com.hazelcast.internal.locksupport.LockStore;
import com.hazelcast.internal.locksupport.LockSupportService;
import com.hazelcast.internal.monitor.LocalRecordStoreStats;
import com.hazelcast.internal.monitor.impl.LocalRecordStoreStatsImpl;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.comparators.ValueComparator;
import com.hazelcast.map.impl.EntryCostEstimator;
import com.hazelcast.map.impl.JsonMetadataInitializer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.record.DataRecordFactory;
import com.hazelcast.map.impl.record.ObjectRecordFactory;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.map.impl.recordstore.BasicRecordStoreLoader;
import com.hazelcast.map.impl.recordstore.CompositeMutationObserver;
import com.hazelcast.map.impl.recordstore.EntryRecordStoreLoader;
import com.hazelcast.map.impl.recordstore.EventJournalWriterMutationObserver;
import com.hazelcast.map.impl.recordstore.IndexingMutationObserver;
import com.hazelcast.map.impl.recordstore.JsonMetadataMutationObserver;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.RecordStoreLoader;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.StorageImpl;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.wan.impl.CallerProvenance;
import javax.annotation.Nonnull;

abstract class AbstractRecordStore
implements RecordStore<Record> {
    protected final int partitionId;
    protected final String name;
    protected final LockStore lockStore;
    protected final MapContainer mapContainer;
    protected final InMemoryFormat inMemoryFormat;
    protected final MapStoreContext mapStoreContext;
    protected final ValueComparator valueComparator;
    protected final MapServiceContext mapServiceContext;
    protected final MapDataStore<Data, Object> mapDataStore;
    protected final SerializationService serializationService;
    protected final CompositeMutationObserver<Record> mutationObserver;
    protected final LocalRecordStoreStatsImpl stats = new LocalRecordStoreStatsImpl();
    protected RecordFactory recordFactory;
    protected Storage<Data, Record> storage;
    protected IndexingMutationObserver<Record> indexingObserver;

    protected AbstractRecordStore(MapContainer mapContainer, int partitionId) {
        this.name = mapContainer.getName();
        this.mapContainer = mapContainer;
        this.partitionId = partitionId;
        this.mapServiceContext = mapContainer.getMapServiceContext();
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        this.serializationService = nodeEngine.getSerializationService();
        this.inMemoryFormat = mapContainer.getMapConfig().getInMemoryFormat();
        this.valueComparator = this.mapServiceContext.getValueComparatorOf(this.inMemoryFormat);
        this.mapStoreContext = mapContainer.getMapStoreContext();
        this.mapDataStore = this.mapStoreContext.getMapStoreManager().getMapDataStore(this.name, partitionId);
        this.lockStore = this.createLockStore();
        this.mutationObserver = new CompositeMutationObserver();
    }

    RecordFactory createRecordFactory() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        switch (mapConfig.getInMemoryFormat()) {
            case BINARY: {
                return new DataRecordFactory(this.mapContainer, this.serializationService);
            }
            case OBJECT: {
                return new ObjectRecordFactory(this.mapContainer, this.serializationService);
            }
        }
        throw new IllegalArgumentException("Invalid storage format: " + mapConfig.getInMemoryFormat());
    }

    @Override
    public void init() {
        this.recordFactory = this.createRecordFactory();
        this.storage = this.createStorage(this.recordFactory, this.inMemoryFormat);
        this.addMutationObservers();
    }

    public ValueComparator getValueComparator() {
        return this.valueComparator;
    }

    public LockStore getLockStore() {
        return this.lockStore;
    }

    protected void addMutationObservers() {
        EventJournalConfig eventJournalConfig = this.mapContainer.getEventJournalConfig();
        if (eventJournalConfig != null && eventJournalConfig.isEnabled()) {
            this.mutationObserver.add(new EventJournalWriterMutationObserver(this.mapServiceContext.getEventJournal(), this.mapContainer, this.partitionId));
        }
        if (this.mapContainer.getMapConfig().getMetadataPolicy() == MetadataPolicy.CREATE_ON_UPDATE) {
            this.mutationObserver.add(new JsonMetadataMutationObserver(this.serializationService, JsonMetadataInitializer.INSTANCE, this.getOrCreateMetadataStore()));
        }
        this.indexingObserver = new IndexingMutationObserver(this, this.serializationService);
        this.mutationObserver.add(this.indexingObserver);
    }

    public IndexingMutationObserver<Record> getIndexingObserver() {
        return this.indexingObserver;
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    @Override
    public EvictionPolicy getEvictionPolicy() {
        return this.getMapContainer().getMapConfig().getEvictionConfig().getEvictionPolicy();
    }

    public boolean persistenceEnabledFor(@Nonnull CallerProvenance provenance) {
        switch (provenance) {
            case WAN: {
                return this.mapContainer.getWanContext().isPersistWanReplicatedData();
            }
            case NOT_WAN: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected provenance: `" + provenance + "`");
    }

    @Override
    public Record createRecord(Data key, Object value, long now) {
        Record record = this.recordFactory.newRecord(key, value);
        record.setCreationTime(now);
        record.setLastUpdateTime(now);
        if (record.getMatchingRecordReaderWriter() == RecordReaderWriter.SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER) {
            record.setLastAccessTime(now);
        }
        this.updateStatsOnPut(false, now);
        return record;
    }

    @Override
    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat memoryFormat) {
        return new StorageImpl(memoryFormat, this.getExpirySystem(), this.serializationService);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public long getOwnedEntryCost() {
        return this.storage.getEntryCostEstimator().getEstimate();
    }

    protected static long getNow() {
        return Clock.currentTimeMillis();
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    protected LockStore createLockStore() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockSupportService lockService = (LockSupportService)nodeEngine.getServiceOrNull("hz:impl:lockService");
        if (lockService == null) {
            return null;
        }
        return lockService.createLockStore(this.partitionId, MapService.getObjectNamespace(this.name));
    }

    @Override
    public int getLockedEntryCount() {
        return this.lockStore.getLockedEntryCount();
    }

    protected RecordStoreLoader createRecordStoreLoader(MapStoreContext mapStoreContext) {
        MapStoreWrapper wrapper = mapStoreContext.getMapStoreWrapper();
        if (wrapper == null) {
            return RecordStoreLoader.EMPTY_LOADER;
        }
        if (wrapper.isWithExpirationTime()) {
            return new EntryRecordStoreLoader(this);
        }
        return new BasicRecordStoreLoader(this);
    }

    protected Data toData(Object value) {
        return this.mapServiceContext.toData(value);
    }

    public void setSizeEstimator(EntryCostEstimator entryCostEstimator) {
        this.storage.setEntryCostEstimator(entryCostEstimator);
    }

    @Override
    public void disposeDeferredBlocks() {
        this.storage.disposeDeferredBlocks();
    }

    @Override
    public Storage<Data, ? extends Record> getStorage() {
        return this.storage;
    }

    protected void updateStatsOnPut(boolean countAsAccess, long now) {
        this.stats.setLastUpdateTime(now);
        if (countAsAccess) {
            this.updateStatsOnGet(now);
        }
    }

    public void updateStatsOnRemove(long now) {
        this.stats.setLastUpdateTime(now);
    }

    protected void updateStatsOnGet(long now) {
        this.stats.setLastAccessTime(now);
        this.stats.increaseHits();
    }

    @Override
    public LocalRecordStoreStatsImpl getLocalRecordStoreStats() {
        return this.stats;
    }

    @Override
    public void setLocalRecordStoreStats(LocalRecordStoreStats stats) {
        this.stats.copyFrom(stats);
    }
}

