/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.impl.pipeline.AbstractStage;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.HashJoinTransform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GeneralHashJoinBuilder<T0> {
    private final GeneralStage<T0> stage0;
    private final PipelineImpl pipelineImpl;
    private final FunctionAdapter fnAdapter;
    private final CreateOutStageFn<T0> createOutStageFn;
    private final Map<Tag<?>, StageAndClause<?, T0, ?, ?>> clauses = new HashMap();

    GeneralHashJoinBuilder(GeneralStage<T0> stage0, CreateOutStageFn<T0> createOutStageFn) {
        this.stage0 = stage0;
        this.pipelineImpl = (PipelineImpl)stage0.getPipeline();
        this.createOutStageFn = createOutStageFn;
        this.fnAdapter = ((ComputeStageImplBase)((Object)stage0)).fnAdapter;
    }

    public <K, T1_IN, T1> Tag<T1> add(BatchStage<T1_IN> stage, JoinClause<K, T0, T1_IN, T1> joinClause) {
        Tag tag = Tag.tag(this.clauses.size());
        this.clauses.put(tag, new StageAndClause<K, T0, T1_IN, T1>(stage, joinClause, false));
        return tag;
    }

    public <K, T1_IN, T1> Tag<T1> addInner(BatchStage<T1_IN> stage, JoinClause<K, T0, T1_IN, T1> joinClause) {
        Tag tag = Tag.tag(this.clauses.size());
        this.clauses.put(tag, new StageAndClause<K, T0, T1_IN, T1>(stage, joinClause, true));
        return tag;
    }

    <R> GeneralStage<R> build0(BiFunctionEx<T0, ItemsByTag, R> mapToOutputFn) {
        Util.checkSerializable(mapToOutputFn, "mapToOutputFn");
        List orderedClauses = this.clauses.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        List upstream = Stream.concat(Stream.of(this.stage0), orderedClauses.stream().map(e -> ((StageAndClause)e.getValue()).stage())).collect(Collectors.toList());
        Stream<JoinClause> joinClauses = orderedClauses.stream().map(e -> ((StageAndClause)e.getValue()).clause());
        List adaptedClauses = joinClauses.map(joinClause -> this.fnAdapter.adaptJoinClause(joinClause)).collect(Collectors.toList());
        BiFunctionEx<?, ItemsByTag, ?> adaptedOutputFn = this.fnAdapter.adaptHashJoinOutputFn(mapToOutputFn);
        HashJoinTransform hashJoinTransform = new HashJoinTransform(upstream.stream().map(AbstractStage::transformOf).collect(Collectors.toList()), adaptedClauses, orderedClauses.stream().map(Map.Entry::getKey).collect(Collectors.toList()), adaptedOutputFn, orderedClauses.stream().map(e -> ((StageAndClause)e.getValue()).inner).collect(Collectors.toList()));
        this.pipelineImpl.connectGeneralStages(upstream, hashJoinTransform);
        return this.createOutStageFn.get(hashJoinTransform, this.fnAdapter, this.pipelineImpl);
    }

    @FunctionalInterface
    static interface CreateOutStageFn<T0> {
        public <R> GeneralStage<R> get(HashJoinTransform<T0, R> var1, FunctionAdapter var2, PipelineImpl var3);
    }

    private static class StageAndClause<K, E0, T1, T1_OUT> {
        private final GeneralStage<T1> stage;
        private final JoinClause<K, E0, T1, T1_OUT> joinClause;
        private final boolean inner;

        StageAndClause(GeneralStage<T1> stage, JoinClause<K, E0, T1, T1_OUT> joinClause, boolean inner) {
            this.stage = stage;
            this.joinClause = joinClause;
            this.inner = inner;
        }

        GeneralStage<T1> stage() {
            return this.stage;
        }

        JoinClause<K, E0, T1, T1_OUT> clause() {
            return this.joinClause;
        }
    }
}

