/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.HazelcastDataConnection;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.security.PermissionsUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHazelcastConnectorSupplier
implements ProcessorSupplier {
    protected final String dataConnectionName;
    protected final String clientXml;
    private transient HazelcastInstance instance;
    private transient SerializationService serializationService;

    AbstractHazelcastConnectorSupplier(@Nullable String dataConnectionName, @Nullable String clientXml) {
        this.clientXml = clientXml;
        this.dataConnectionName = dataConnectionName;
    }

    public static ProcessorSupplier ofMap(@Nullable String clientXml, final @Nonnull FunctionEx<HazelcastInstance, Processor> procFn) {
        return new AbstractHazelcastConnectorSupplier(null, clientXml){
            private static final long serialVersionUID = 1L;

            @Override
            public void init(@Nonnull ProcessorSupplier.Context context) {
                PermissionsUtil.checkPermission(procFn, context);
                super.init(context);
            }

            @Override
            protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
                return (Processor)procFn.apply(instance);
            }
        };
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.createHzClient(context);
    }

    private void createHzClient(ProcessorSupplier.Context context) {
        if (this.dataConnectionName != null) {
            HazelcastDataConnection hazelcastDataConnection = context.dataConnectionService().getAndRetainDataConnection(this.dataConnectionName, HazelcastDataConnection.class);
            try {
                this.instance = hazelcastDataConnection.getClient();
                this.serializationService = ((HazelcastClientProxy)this.instance).getSerializationService();
            }
            finally {
                hazelcastDataConnection.release();
            }
        } else if (this.clientXml != null) {
            this.instance = HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(this.clientXml));
            this.serializationService = ((HazelcastClientProxy)this.instance).getSerializationService();
        } else {
            this.instance = context.hazelcastInstance();
            this.serializationService = ((Contexts.ProcSupplierCtx)context).serializationService();
        }
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        return Stream.generate(() -> this.createProcessor(this.instance, this.serializationService)).limit(count).collect(Collectors.toList());
    }

    protected abstract Processor createProcessor(HazelcastInstance var1, SerializationService var2);

    boolean isLocal() {
        return this.clientXml == null && this.dataConnectionName == null;
    }

    boolean isRemote() {
        return !this.isLocal();
    }

    @Override
    public void close(@Nullable Throwable error) {
        if (!this.isLocal() && this.instance != null) {
            this.instance.shutdown();
        }
    }
}

