/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class StringUtil {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final Locale LOCALE_INTERNAL = Locale.ROOT;
    public static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)(\\.(\\d+))?(-\\w+(?:-\\d+)?)?(-SNAPSHOT)?$");

    private StringUtil() {
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static boolean isNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.isEmpty();
    }

    public static boolean isNullOrEmptyAfterTrim(String s) {
        if (s == null) {
            return true;
        }
        return s.isBlank();
    }

    public static boolean isAllNullOrEmptyAfterTrim(String ... values) {
        if (values == null) {
            return false;
        }
        return Arrays.stream(values).noneMatch(StringUtil::isNullOrEmptyAfterTrim);
    }

    public static boolean isAnyNullOrEmptyAfterTrim(String ... values) {
        if (values == null) {
            return false;
        }
        return Arrays.stream(values).anyMatch(s -> !StringUtil.isNullOrEmptyAfterTrim(s));
    }

    public static String upperCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toUpperCase(LOCALE_INTERNAL);
    }

    public static String lowerCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toLowerCase(LOCALE_INTERNAL);
    }

    public static String timeToString(long timeMillis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateFormat.format(new Date(timeMillis));
    }

    public static String timeToStringFriendly(long timeMillis) {
        return timeMillis == 0L ? "never" : StringUtil.timeToString(timeMillis);
    }

    public static int indexOf(String input, char ch, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            if (input.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String input, char ch) {
        return StringUtil.indexOf(input, ch, 0);
    }

    public static int lastIndexOf(String input, char ch, int offset) {
        for (int i = input.length() - 1 - offset; i >= 0; --i) {
            if (input.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String input, char ch) {
        return StringUtil.lastIndexOf(input, ch, 0);
    }

    public static String[] tokenizeVersionString(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String[] tokens = new String[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                tokens[i] = matcher.group(i + 1);
            }
            return tokens;
        }
        return null;
    }

    public static String trim(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("^\\s+|\\s+$", "");
    }

    public static String[] splitByComma(String input, boolean allowEmpty) {
        if (input == null) {
            return null;
        }
        String[] splitWithEmptyValues = StringUtil.trim(input).split("\\s*,\\s*", -1);
        return allowEmpty ? splitWithEmptyValues : StringUtil.subtraction(splitWithEmptyValues, new String[]{""});
    }

    public static String[] intersection(String[] arr1, String[] arr2) {
        if (arr1 == null || arr2 == null) {
            return null;
        }
        if (arr1.length == 0 || arr2.length == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr1));
        list.retainAll(Arrays.asList(arr2));
        return list.toArray(new String[0]);
    }

    public static String[] subtraction(String[] arr1, String[] arr2) {
        if (arr1 == null || arr1.length == 0 || arr2 == null || arr2.length == 0) {
            return arr1;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr1));
        list.removeAll(Arrays.asList(arr2));
        return list.toArray(new String[0]);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 != null && str2 != null && (str1 == str2 || StringUtil.lowerCaseInternal(str1).equals(StringUtil.lowerCaseInternal(str2)));
    }

    public static String stripTrailingSlash(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return str;
        }
        if (str.charAt(str.length() - 1) == '/') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String resolvePlaceholders(String pattern, String placeholderNamespace, Map<String, Object> variableValues) {
        int endIndex;
        StringBuilder sb = new StringBuilder(pattern);
        String placeholderPrefix = "$" + placeholderNamespace + "{";
        int startIndex = sb.indexOf(placeholderPrefix);
        while (startIndex > -1 && (endIndex = sb.indexOf("}", startIndex)) != -1) {
            String variableName = sb.substring(startIndex + placeholderPrefix.length(), endIndex);
            Object variableValue = variableValues.get(variableName);
            if (variableValue != null) {
                String valueStr = variableValue.toString();
                sb.replace(startIndex, endIndex + 1, valueStr);
                endIndex = startIndex + valueStr.length();
            }
            startIndex = sb.indexOf(placeholderPrefix, endIndex);
        }
        return sb.toString();
    }

    public static <T> String toString(Collection<T> collection) {
        return collection.stream().map(Objects::toString).collect(Collectors.joining(LINE_SEPARATOR));
    }

    public static <T> String toString(T[] arr) {
        return Arrays.stream(arr).map(Objects::toString).collect(Collectors.joining(LINE_SEPARATOR));
    }

    public static String shorten(String s, int maxLength) {
        Preconditions.checkPositive("maxLength", maxLength);
        if (s == null || s.length() <= maxLength) {
            return s;
        }
        return s.substring(maxLength - 1) + "\u2026";
    }

    public static String removeCharacter(String str, char charToRemove) {
        if (str == null || str.indexOf(charToRemove) == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == charToRemove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static boolean isBoolean(String value) {
        return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true");
    }
}

