/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.events;

import com.hazelcast.internal.config.ConfigNamespace;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.events.AbstractConfigUpdateEvent;
import com.hazelcast.internal.management.events.EventMetadata;
import java.util.UUID;

public class ConfigUpdateProgressEvent
extends AbstractConfigUpdateEvent {
    private final int totalChangeCount;
    private final int appliedChangeCount;
    private final ConfigNamespace namespace;

    public ConfigUpdateProgressEvent(UUID configUpdateProcessId, int totalChangeCount, int appliedChangeCount, ConfigNamespace namespace) {
        super(configUpdateProcessId);
        this.totalChangeCount = totalChangeCount;
        this.appliedChangeCount = appliedChangeCount;
        this.namespace = namespace;
    }

    @Override
    public EventMetadata.EventType getType() {
        return EventMetadata.EventType.CONFIG_UPDATE_PROGRESS;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.add("totalChangeCount", this.totalChangeCount);
        json.add("appliedChangeCount", this.appliedChangeCount);
        json.add("configName", this.namespace.getConfigName());
        json.add("sectionName", this.namespace.getSectionName());
        return json;
    }

    public int getTotalChangeCount() {
        return this.totalChangeCount;
    }

    public int getAppliedChangeCount() {
        return this.appliedChangeCount;
    }

    public ConfigNamespace getNamespace() {
        return this.namespace;
    }
}

