/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.memcache;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.TextCommandServiceImpl;
import com.hazelcast.internal.ascii.memcache.EntryConverter;
import com.hazelcast.internal.ascii.memcache.IncrementCommand;
import com.hazelcast.internal.ascii.memcache.MemcacheCommandProcessor;
import com.hazelcast.internal.ascii.memcache.MemcacheEntry;
import com.hazelcast.internal.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class IncrementCommandProcessor
extends MemcacheCommandProcessor<IncrementCommand> {
    private final EntryConverter entryConverter;

    public IncrementCommandProcessor(TextCommandServiceImpl textCommandService, EntryConverter entryConverter) {
        super(textCommandService);
        this.entryConverter = entryConverter;
    }

    @Override
    public void handle(IncrementCommand incrementCommand) {
        String key;
        try {
            key = URLDecoder.decode(incrementCommand.getKey(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HazelcastException(e);
        }
        Object mapName = "hz_memcache_default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = "hz_memcache_" + key.substring(0, index);
            key = key.substring(index + 1);
        }
        try {
            this.textCommandService.lock((String)mapName, key);
        }
        catch (Exception e) {
            incrementCommand.setResponse(TextCommandConstants.NOT_FOUND);
            if (incrementCommand.shouldReply()) {
                this.textCommandService.sendResponse(incrementCommand);
            }
            return;
        }
        this.incrementUnderLock(incrementCommand, key, (String)mapName);
        this.textCommandService.unlock((String)mapName, key);
        if (incrementCommand.shouldReply()) {
            this.textCommandService.sendResponse(incrementCommand);
        }
    }

    private void incrementUnderLock(IncrementCommand incrementCommand, String key, String mapName) {
        Object value = this.textCommandService.get(mapName, key);
        if (value != null) {
            MemcacheEntry entry = this.entryConverter.toEntry(incrementCommand.getKey(), value);
            String currentCachedValue = new String(entry.getValue(), StandardCharsets.UTF_8);
            try {
                String newCachedValue = this.doIncrement(incrementCommand, currentCachedValue);
                this.updateHitCount(incrementCommand);
                byte[] newCachedValueBytes = StringUtil.stringToBytes(newCachedValue);
                MemcacheEntry newValue = new MemcacheEntry(key, newCachedValueBytes, entry.getFlag());
                this.textCommandService.put(mapName, key, newValue);
                incrementCommand.setResponse(IncrementCommandProcessor.concatenate(newCachedValueBytes, TextCommandConstants.RETURN));
            }
            catch (NumberFormatException e) {
                incrementCommand.setResponse(IncrementCommandProcessor.concatenate(IncrementCommandProcessor.concatenate(TextCommandConstants.CLIENT_ERROR, StringUtil.stringToBytes(e.getMessage())), TextCommandConstants.RETURN));
            }
        } else {
            if (incrementCommand.getType() == TextCommandConstants.TextCommandType.INCREMENT) {
                this.textCommandService.incrementIncMissCount();
            } else {
                this.textCommandService.incrementDecrMissCount();
            }
            incrementCommand.setResponse(TextCommandConstants.NOT_FOUND);
        }
    }

    @Override
    public void handleRejection(IncrementCommand incrementCommand) {
        incrementCommand.setResponse(TextCommandConstants.NOT_FOUND);
        if (incrementCommand.shouldReply()) {
            this.textCommandService.sendResponse(incrementCommand);
        }
    }

    private String doIncrement(IncrementCommand incrementCommand, String currentValue) {
        long current = Long.parseUnsignedLong(currentValue);
        long incrementAmount = incrementCommand.getValue();
        if (incrementCommand.getType() == TextCommandConstants.TextCommandType.INCREMENT) {
            return Long.toUnsignedString(current + incrementAmount);
        }
        if (incrementCommand.getType() == TextCommandConstants.TextCommandType.DECREMENT) {
            if (Long.compareUnsigned(current, incrementAmount) < 0) {
                return "0";
            }
            return Long.toUnsignedString(current - incrementAmount);
        }
        throw new IllegalStateException("Unexpected command type");
    }

    private void updateHitCount(IncrementCommand incrementCommand) {
        if (incrementCommand.getType() == TextCommandConstants.TextCommandType.INCREMENT) {
            this.textCommandService.incrementIncHitCount();
        } else if (incrementCommand.getType() == TextCommandConstants.TextCommandType.DECREMENT) {
            this.textCommandService.incrementDecrHitCount();
        }
    }
}

