/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.dto;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class VoteRequest
implements IdentifiedDataSerializable {
    private RaftEndpoint candidate;
    private int term;
    private int lastLogTerm;
    private long lastLogIndex;
    private boolean disruptive;

    public VoteRequest() {
    }

    public VoteRequest(RaftEndpoint candidate, int term, int lastLogTerm, long lastLogIndex, boolean disruptive) {
        this.term = term;
        this.candidate = candidate;
        this.lastLogTerm = lastLogTerm;
        this.lastLogIndex = lastLogIndex;
        this.disruptive = disruptive;
    }

    public RaftEndpoint candidate() {
        return this.candidate;
    }

    public int term() {
        return this.term;
    }

    public int lastLogTerm() {
        return this.lastLogTerm;
    }

    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    public boolean isDisruptive() {
        return this.disruptive;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.term);
        out.writeObject(this.candidate);
        out.writeInt(this.lastLogTerm);
        out.writeLong(this.lastLogIndex);
        out.writeBoolean(this.disruptive);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.term = in.readInt();
        this.candidate = (RaftEndpoint)in.readObject();
        this.lastLogTerm = in.readInt();
        this.lastLogIndex = in.readLong();
        this.disruptive = in.readBoolean();
    }

    public String toString() {
        return "VoteRequest{candidate=" + this.candidate + ", term=" + this.term + ", lastLogTerm=" + this.lastLogTerm + ", lastLogIndex=" + this.lastLogIndex + ", disruptive=" + this.disruptive + "}";
    }
}

