/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.exception.CPSubsystemException;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.internal.CPSubsystemImpl;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.Collection;

public class GetCPObjectInfosOp
extends Operation
implements IdentifiedDataSerializable,
PartitionAwareOperation {
    private CPGroupId groupId;
    private String serviceName;
    private boolean returnTombstone;
    private Collection<String> result;

    public GetCPObjectInfosOp() {
    }

    public GetCPObjectInfosOp(CPGroupId groupId, String serviceName, boolean returnTombstone) {
        this.groupId = groupId;
        this.serviceName = serviceName;
        this.returnTombstone = returnTombstone;
    }

    @Override
    public void run() throws Exception {
        RaftService service = (RaftService)this.getNodeEngine().getService("hz:core:raft");
        RaftNode raftNode = service.getRaftNode(this.groupId);
        if (raftNode == null) {
            throw new CPSubsystemException("This member doesn't know group id " + this.groupId, null);
        }
        if (!raftNode.getLocalMember().equals(raftNode.getLeader())) {
            throw new NotLeaderException(this.groupId, raftNode.getLocalMember(), raftNode.getLeader());
        }
        CPSubsystemImpl cpSubsystem = (CPSubsystemImpl)this.getNodeEngine().getHazelcastInstance().getCPSubsystem();
        this.result = cpSubsystem.getCPObjectNames(this.groupId, this.serviceName, this.returnTombstone);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 53;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.groupId);
        out.writeString(this.serviceName);
        out.writeBoolean(this.returnTombstone);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.groupId = (CPGroupId)in.readObject();
        this.serviceName = in.readString();
        this.returnTombstone = in.readBoolean();
    }
}

