/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.lock;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.datastructures.lock.AcquireResult;
import com.hazelcast.cp.internal.datastructures.lock.Lock;
import com.hazelcast.cp.internal.datastructures.lock.LockEndpoint;
import com.hazelcast.cp.internal.datastructures.lock.LockInvocationKey;
import com.hazelcast.cp.internal.datastructures.lock.LockOwnershipState;
import com.hazelcast.cp.internal.datastructures.lock.LockRegistry;
import com.hazelcast.cp.internal.datastructures.lock.ReleaseResult;
import com.hazelcast.cp.internal.datastructures.lock.proxy.FencedLockProxy;
import com.hazelcast.cp.internal.datastructures.spi.blocking.AbstractBlockingService;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LockService
extends AbstractBlockingService<LockInvocationKey, Lock, LockRegistry>
implements DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:raft:lockService";
    private final ConcurrentMap<String, FencedLockProxy> proxies = new ConcurrentHashMap<String, FencedLockProxy>();

    public LockService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    protected void initImpl() {
        super.initImpl();
        if (this.nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES)) {
            this.nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    public AcquireResult acquire(CPGroupId groupId, String name, LockInvocationKey key, long timeoutMs) {
        this.heartbeatSession(groupId, key.sessionId());
        LockRegistry registry = (LockRegistry)this.getOrInitRegistry(groupId);
        AcquireResult result = registry.acquire(name, key, timeoutMs);
        if (this.logger.isFineEnabled()) {
            if (result.status() == AcquireResult.AcquireStatus.SUCCESSFUL) {
                this.logger.fine("Lock[" + name + "] in " + groupId + " acquired by <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex() + ". new lock state: " + registry.getLockOwnershipState(name));
            } else if (result.status() == AcquireResult.AcquireStatus.WAIT_KEY_ADDED) {
                this.logger.fine("Lock[" + name + "] in " + groupId + " wait key added for <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex() + ". lock state: " + registry.getLockOwnershipState(name));
            } else if (result.status() == AcquireResult.AcquireStatus.FAILED) {
                this.logger.fine("Lock[" + name + "] in " + groupId + " acquire failed for <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex() + ". lock state: " + registry.getLockOwnershipState(name));
            }
        }
        if (result.status() == AcquireResult.AcquireStatus.WAIT_KEY_ADDED) {
            this.scheduleTimeout(groupId, name, key.invocationUid(), timeoutMs);
        }
        this.notifyCancelledWaitKeys(groupId, name, result.cancelledWaitKeys());
        return result;
    }

    public boolean release(CPGroupId groupId, long commitIndex, String name, LockEndpoint endpoint, UUID invocationUid) {
        this.heartbeatSession(groupId, endpoint.sessionId());
        LockRegistry registry = this.getLockRegistryOrFail(groupId, name);
        ReleaseResult result = registry.release(name, endpoint, invocationUid);
        if (this.logger.isFineEnabled()) {
            if (result.success()) {
                this.logger.fine("Lock[" + name + "] in " + groupId + " released by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex + ". new lock state: " + result.ownership());
            } else {
                this.logger.fine("Lock[" + name + "] in " + groupId + " not released by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex + ". lock state: " + registry.getLockOwnershipState(name));
            }
        }
        if (result.success()) {
            this.notifyWaitKeys(groupId, name, result.completedWaitKeys(), result.ownership().getFence());
            return result.ownership().isLockedBy(endpoint.sessionId(), endpoint.threadId());
        }
        this.notifyCancelledWaitKeys(groupId, name, result.completedWaitKeys());
        throw new IllegalMonitorStateException("Current thread is not owner of the lock!");
    }

    private void notifyCancelledWaitKeys(CPGroupId groupId, String name, Collection<LockInvocationKey> keys) {
        if (keys.isEmpty()) {
            return;
        }
        this.notifyWaitKeys(groupId, name, keys, new WaitKeyCancelledException());
    }

    public LockOwnershipState getLockOwnershipState(CPGroupId groupId, String name) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(name);
        LockRegistry registry = (LockRegistry)this.getRegistryOrNull(groupId);
        return registry != null ? registry.getLockOwnershipState(name) : LockOwnershipState.NOT_LOCKED;
    }

    private LockRegistry getLockRegistryOrFail(CPGroupId groupId, String name) {
        Preconditions.checkNotNull(groupId);
        LockRegistry registry = (LockRegistry)this.getRegistryOrNull(groupId);
        if (registry == null) {
            throw new IllegalMonitorStateException("Lock registry of " + groupId + " not found for Lock[" + name + "]");
        }
        return registry;
    }

    @Override
    protected LockRegistry createNewRegistry(CPGroupId groupId) {
        return new LockRegistry(this.nodeEngine.getConfig().getCPSubsystemConfig(), groupId);
    }

    @Override
    protected Object expiredWaitKeyResponse() {
        return 0L;
    }

    @Override
    protected void onRegistryRestored(LockRegistry registry) {
        registry.setCpSubsystemConfig(this.nodeEngine.getConfig().getCPSubsystemConfig());
    }

    @Override
    protected String serviceName() {
        return SERVICE_NAME;
    }

    public FencedLock createProxy(String proxyName) {
        FencedLockProxy proxy;
        FencedLockProxy existing;
        proxyName = RaftService.withoutDefaultGroupName(proxyName);
        do {
            if ((proxy = (FencedLockProxy)this.proxies.get(proxyName)) == null) continue;
            RaftGroupId groupId = this.raftService.createRaftGroupForProxy(proxyName);
            if (!((RaftGroupId)proxy.getGroupId()).equals(groupId)) {
                this.proxies.remove(proxyName, proxy);
                continue;
            }
            return proxy;
        } while ((existing = this.proxies.putIfAbsent(proxyName, proxy = this.doCreateProxy(proxyName))) != null);
        return proxy;
    }

    @Override
    public void onCPSubsystemRestart() {
        super.onCPSubsystemRestart();
        this.proxies.clear();
    }

    private FencedLockProxy doCreateProxy(String proxyName) {
        try {
            RaftGroupId groupId = this.raftService.createRaftGroupForProxy(proxyName);
            return new FencedLockProxy(this.nodeEngine, groupId, proxyName, RaftService.getObjectNameForProxy(proxyName));
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor root = descriptor.withPrefix("cp.lock");
        for (CPGroupId groupId : this.getGroupIdSet()) {
            LockRegistry registry = (LockRegistry)this.getRegistryOrNull(groupId);
            for (Lock lock : registry.getAllLocks()) {
                MetricDescriptor desc = root.copy().withDiscriminator("id", lock.getName() + "@" + groupId.getName()).withTag("name", lock.getName()).withTag("group", groupId.getName());
                context.collect(desc.copy().withUnit(ProbeUnit.COUNT).withMetric("acquireLimit"), lock.lockCountLimit());
                LockInvocationKey owner = lock.owner();
                int lockCount = lock.lockCount();
                if (owner != null && lockCount > 0) {
                    MetricDescriptor copy = desc.copy().withTag("sessionId", String.valueOf(owner.sessionId())).withTag("qualifiedSessionId", owner.sessionId() + "@" + groupId.getName());
                    context.collect(copy.withMetric("ownerSessionId"), owner.sessionId());
                    context.collect(copy.withTag("owner", owner.callerAddress().toString()).withMetric("owner"), 0L);
                    context.collect(copy.withUnit(ProbeUnit.COUNT).withMetric("lockCount"), lockCount);
                    continue;
                }
                context.collect(desc.copy().withUnit(ProbeUnit.COUNT).withMetric("lockCount"), 0L);
            }
        }
    }

    @Override
    public boolean destroyRaftObject(CPGroupId groupId, String name) {
        boolean result = super.destroyRaftObject(groupId, name);
        String proxyName = RaftService.withoutDefaultGroupName(name + "@" + groupId.getName());
        this.proxies.remove(proxyName);
        return result;
    }
}

