/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.lock;

import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.lock.AcquireResult;
import com.hazelcast.cp.internal.datastructures.lock.Lock;
import com.hazelcast.cp.internal.datastructures.lock.LockDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.lock.LockEndpoint;
import com.hazelcast.cp.internal.datastructures.lock.LockInvocationKey;
import com.hazelcast.cp.internal.datastructures.lock.LockOwnershipState;
import com.hazelcast.cp.internal.datastructures.lock.ReleaseResult;
import com.hazelcast.cp.internal.datastructures.spi.blocking.ResourceRegistry;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

class LockRegistry
extends ResourceRegistry<LockInvocationKey, Lock>
implements IdentifiedDataSerializable {
    private CPSubsystemConfig cpSubsystemConfig;

    LockRegistry() {
    }

    LockRegistry(CPSubsystemConfig cpSubsystemConfig, CPGroupId groupId) {
        super(groupId);
        this.cpSubsystemConfig = cpSubsystemConfig;
    }

    public void setCpSubsystemConfig(CPSubsystemConfig cpSubsystemConfig) {
        this.cpSubsystemConfig = cpSubsystemConfig;
    }

    @Override
    protected Lock createNewResource(CPGroupId groupId, String name) {
        FencedLockConfig lockConfig = this.cpSubsystemConfig.findLockConfig(name);
        int lockCountLimit = lockConfig != null ? lockConfig.getLockAcquireLimit() : 0;
        return new Lock(groupId, name, lockCountLimit);
    }

    protected LockRegistry cloneForSnapshot() {
        LockRegistry clone = new LockRegistry();
        clone.groupId = this.groupId;
        for (Map.Entry e : this.resources.entrySet()) {
            clone.resources.put((String)e.getKey(), ((Lock)e.getValue()).cloneForSnapshot());
        }
        clone.destroyedNames.addAll(this.destroyedNames);
        clone.waitTimeouts.putAll(this.waitTimeouts);
        return clone;
    }

    AcquireResult acquire(String name, LockInvocationKey key, long timeoutMs) {
        AcquireResult result = ((Lock)this.getOrInitResource(name)).acquire(key, timeoutMs != 0L);
        for (LockInvocationKey cancelled : result.cancelledWaitKeys()) {
            this.removeWaitKey(name, cancelled);
        }
        if (result.status() == AcquireResult.AcquireStatus.WAIT_KEY_ADDED) {
            this.addWaitKey(name, key, timeoutMs);
        }
        return result;
    }

    ReleaseResult release(String name, LockEndpoint endpoint, UUID invocationUid) {
        Lock lock = (Lock)this.getResourceOrNull(name);
        if (lock == null) {
            return ReleaseResult.FAILED;
        }
        ReleaseResult result = lock.release(endpoint, invocationUid);
        for (LockInvocationKey key : result.completedWaitKeys()) {
            this.removeWaitKey(name, key);
        }
        return result;
    }

    LockOwnershipState getLockOwnershipState(String name) {
        Lock lock = (Lock)this.getResourceOrNull(name);
        return lock != null ? lock.lockOwnershipState() : LockOwnershipState.NOT_LOCKED;
    }

    Collection<Lock> getAllLocks() {
        return this.resources.values();
    }

    @Override
    public int getFactoryId() {
        return LockDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

