/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.event.impl;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.event.CPGroupAvailabilityEvent;
import com.hazelcast.cp.event.impl.CpEventDataSerializerHook;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class CPGroupAvailabilityEventImpl
implements CPGroupAvailabilityEvent,
IdentifiedDataSerializable,
Versioned {
    private CPGroupId groupId;
    private Collection<CPMember> members;
    private Collection<CPMember> missingMembers;
    private boolean isShutdown;

    public CPGroupAvailabilityEventImpl() {
    }

    public CPGroupAvailabilityEventImpl(CPGroupId groupId, Collection<CPMember> members, Collection<CPMember> missingMembers) {
        this(groupId, members, missingMembers, false);
    }

    public CPGroupAvailabilityEventImpl(CPGroupId groupId, Collection<CPMember> members, Collection<CPMember> missingMembers, boolean isShutdown) {
        this.groupId = groupId;
        this.members = members;
        this.missingMembers = missingMembers;
        this.isShutdown = isShutdown;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public CPGroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public Collection<CPMember> getUnavailableMembers() {
        return Collections.unmodifiableCollection(this.missingMembers);
    }

    @Override
    public Collection<CPMember> getGroupMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    @Override
    public int getMajority() {
        return this.members.size() / 2 + 1;
    }

    @Override
    public boolean isMajorityAvailable() {
        HashSet<CPMember> leftMembers = new HashSet<CPMember>(this.members);
        leftMembers.removeAll(this.missingMembers);
        return leftMembers.size() > 1 && this.missingMembers.size() < this.getMajority();
    }

    @Override
    public boolean isMetadataGroup() {
        return "METADATA".equals(this.groupId.getName());
    }

    @Override
    public int getFactoryId() {
        return CpEventDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.groupId);
        SerializationUtil.writeCollection(this.members, out);
        SerializationUtil.writeCollection(this.missingMembers, out);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            out.writeBoolean(this.isShutdown);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.groupId = (CPGroupId)in.readObject();
        this.members = SerializationUtil.readCollection(in);
        this.missingMembers = SerializationUtil.readCollection(in);
        this.isShutdown = in.getVersion().isGreaterOrEqual(Versions.V5_4) ? in.readBoolean() : false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CPGroupAvailabilityEventImpl that = (CPGroupAvailabilityEventImpl)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (this.members.size() != that.members.size()) {
            return false;
        }
        if (this.missingMembers.size() != that.missingMembers.size()) {
            return false;
        }
        if (!this.missingMembers.containsAll(that.missingMembers)) {
            return false;
        }
        if (!this.members.containsAll(that.members)) {
            return false;
        }
        return this.isShutdown == that.isShutdown;
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        for (CPMember member : this.members) {
            result = 31 * result + member.hashCode();
        }
        for (CPMember member : this.missingMembers) {
            result = 31 * result + member.hashCode();
        }
        result = 31 * result + Boolean.hashCode(this.isShutdown);
        return result;
    }

    public String toString() {
        return "CPGroupAvailabilityEvent{groupId=" + this.groupId + ", members=" + this.members + ", missingMembers=" + this.missingMembers + ", isShutdown=" + this.isShutdown + "}";
    }
}

