/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapClearCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapFetchEntryViewsCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutAllWithMetadataCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapValuesCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.map.impl.iterator.ClientReplicatedMapEntryViewIterator;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.LocalReplicatedMapStats;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.spi.impl.UnmodifiableLazySet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientReplicatedMapProxy<K, V>
extends ClientProxy
implements ReplicatedMap<K, V> {
    private static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    private static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private static final String NULL_TIMEUNIT_IS_NOT_ALLOWED = "Null time unit is not allowed!";
    private static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    private static final String NULL_PREDICATE_IS_NOT_ALLOWED = "Null predicate is not allowed!";
    private int targetPartitionId;
    private volatile NearCache<K, V> nearCache;
    private volatile UUID invalidationListenerId;

    public ClientReplicatedMapProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
    }

    @Override
    protected void onInitialize() {
        int partitionCount = this.getContext().getPartitionService().getPartitionCount();
        this.targetPartitionId = ThreadLocalRandomProvider.get().nextInt(partitionCount);
        this.initNearCache();
    }

    private void initNearCache() {
        NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            if (nearCacheConfig.isSerializeKeys()) {
                throw new InvalidConfigurationException("ReplicatedMap doesn't support serializeKeys option of NearCacheConfig");
            }
            this.nearCache = this.getContext().getNearCacheManager(this.getServiceName()).getOrCreateNearCache(this.name, nearCacheConfig);
            if (nearCacheConfig.isInvalidateOnChange()) {
                this.registerInvalidationListener();
            }
        }
    }

    @Override
    protected void postDestroy() {
        try {
            this.destroyNearCache();
        }
        finally {
            super.postDestroy();
        }
    }

    @Override
    protected void onShutdown() {
        try {
            this.destroyNearCache();
        }
        finally {
            super.onShutdown();
        }
    }

    private void destroyNearCache() {
        if (this.nearCache != null) {
            this.removeNearCacheInvalidationListener();
            this.getContext().getNearCacheManager(this.getServiceName()).destroyNearCache(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeUnit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        try {
            Data valueData = this.toData(value);
            Data keyData = this.toData(key);
            ClientMessage request = ReplicatedMapPutCodec.encodeRequest(this.name, keyData, valueData, timeUnit.toMillis(ttl));
            ClientMessage response = (ClientMessage)this.invoke(request, keyData);
            Object t = this.toObject(ReplicatedMapPutCodec.decodeResponse(response));
            return (V)t;
        }
        finally {
            this.invalidate(key);
        }
    }

    @Override
    public int size() {
        ClientMessage request = ReplicatedMapSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        return ReplicatedMapSizeCodec.decodeResponse(response);
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = ReplicatedMapIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        return ReplicatedMapIsEmptyCodec.decodeResponse(response);
    }

    @Override
    public boolean containsKey(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapContainsKeyCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return ReplicatedMapContainsKeyCodec.decodeResponse(response);
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = ReplicatedMapContainsValueCodec.encodeRequest(this.name, valueData);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        return ReplicatedMapContainsValueCodec.decodeResponse(response);
    }

    @Override
    public V get(@Nonnull Object userKey) {
        K key = this.validateKey(userKey);
        V cachedValue = this.getCachedValue(key);
        if (cachedValue != NearCache.NOT_CACHED) {
            return cachedValue;
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.tryReserveForUpdate(key, keyData);
            ClientMessage request = ReplicatedMapGetCodec.encodeRequest(this.name, keyData);
            ClientMessage response = (ClientMessage)this.invoke(request, keyData);
            Object value = this.toObject(ReplicatedMapGetCodec.decodeResponse(response));
            this.tryPublishReserved(key, value, reservationId);
            return (V)value;
        }
        catch (Throwable t) {
            this.invalidate(key);
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@Nonnull Object userKey) {
        K key = this.validateKey(userKey);
        try {
            Data keyData = this.toData(key);
            ClientMessage request = ReplicatedMapRemoveCodec.encodeRequest(this.name, keyData);
            ClientMessage response = (ClientMessage)this.invoke(request, keyData);
            Object t = this.toObject(ReplicatedMapRemoveCodec.decodeResponse(response));
            return (V)t;
        }
        finally {
            this.invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> map) {
        Preconditions.checkNotNull(map, "Entries cannot be null");
        try {
            ArrayList<Map.Entry<Data, Data>> dataEntries = new ArrayList<Map.Entry<Data, Data>>(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Data keyData = this.toData(entry.getKey());
                Data valueData = this.toData(entry.getValue());
                dataEntries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData));
            }
            ClientMessage request = ReplicatedMapPutAllCodec.encodeRequest(this.name, dataEntries);
            this.invoke(request);
        }
        finally {
            if (this.nearCache != null) {
                for (K key : map.keySet()) {
                    this.invalidate(key);
                }
            }
        }
    }

    @Override
    public void clear() {
        try {
            ClientMessage request = ReplicatedMapClearCodec.encodeRequest(this.name);
            this.invoke(request);
        }
        finally {
            if (this.nearCache != null) {
                this.nearCache.clear();
            }
        }
    }

    @Override
    public boolean removeEntryListener(@Nonnull UUID registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ReplicatedMapEventHandler handler = new ReplicatedMapEventHandler(listener);
        return this.registerListener(this.createEntryListenerCodec(), handler);
    }

    private ListenerMessageCodec createEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nullable K key) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ReplicatedMapToKeyEventHandler handler = new ReplicatedMapToKeyEventHandler(listener);
        return key != null ? this.registerListener(this.createEntryListenerToKeyCodec(keyData), handler) : this.registerListener(this.createEntryListenerCodec(), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyCodec(final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerToKeyCodec.encodeRequest(ClientReplicatedMapProxy.this.name, keyData, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerToKeyCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        Data predicateData = this.toData(predicate);
        ReplicatedMapWithPredicateEventHandler handler = new ReplicatedMapWithPredicateEventHandler(listener);
        return this.registerListener(this.createEntryListenerWithPredicateCodec(predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerWithPredicateCodec(final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerWithPredicateCodec.encodeRequest(ClientReplicatedMapProxy.this.name, predicateData, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerWithPredicateCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nonnull Predicate<K, V> predicate, @Nullable K key) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ReplicatedMapToKeyWithPredicateEventHandler handler = new ReplicatedMapToKeyWithPredicateEventHandler(listener);
        return key != null ? this.registerListener(this.createEntryListenerToKeyWithPredicateCodec(keyData, predicateData), handler) : this.registerListener(this.createEntryListenerWithPredicateCodec(predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyWithPredicateCodec(final Data keyData, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.encodeRequest(ClientReplicatedMapProxy.this.name, keyData, predicateData, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        ClientMessage request = ReplicatedMapKeySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        return new UnmodifiableLazySet(ReplicatedMapKeySetCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    @Nonnull
    public LocalReplicatedMapStats getReplicatedMapStats() {
        throw new UnsupportedOperationException("Replicated Map statistics are not available for client!");
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        ClientMessage request = ReplicatedMapValuesCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        return new UnmodifiableLazyList(ReplicatedMapValuesCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    @Nonnull
    public Collection<V> values(@Nullable Comparator<V> comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = ReplicatedMapEntrySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        return new UnmodifiableLazySet(ReplicatedMapEntrySetCodec.decodeResponse(response), this.getSerializationService());
    }

    public UUID addNearCacheInvalidationListener(EventHandler handler) {
        return this.registerListener(this.createNearCacheInvalidationListenerCodec(), handler);
    }

    public CompletableFuture<Void> putAllWithMetadataAsync(@Nonnull Collection<ReplicatedMapEntryViewHolder> entryViewHolders) {
        Preconditions.checkNotNull(entryViewHolders, "Null argument entryViewHolders is not allowed");
        InternalCompletableFuture<Void> resultFuture = new InternalCompletableFuture<Void>();
        if (entryViewHolders.isEmpty()) {
            resultFuture.complete(null);
            return resultFuture;
        }
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        HashMap partitionToList = new HashMap();
        for (ReplicatedMapEntryViewHolder holder : entryViewHolders) {
            Data key = holder.getKey();
            int partitionId = partitionService.getPartitionId(key);
            if (!partitionToList.containsKey(partitionId)) {
                partitionToList.put(partitionId, new ArrayList());
            }
            ((List)partitionToList.get(partitionId)).add(holder);
        }
        AtomicInteger counter = new AtomicInteger(partitionToList.size());
        Iterator iterator = partitionToList.keySet().iterator();
        while (iterator.hasNext()) {
            int partitionId = (Integer)iterator.next();
            List entryViews = (List)partitionToList.get(partitionId);
            ClientMessage request = ReplicatedMapPutAllWithMetadataCodec.encodeRequest(this.name, entryViews, partitionId);
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke();
            future.whenCompleteAsync((clientMessage, throwable) -> {
                if (throwable != null) {
                    resultFuture.completeExceptionally((Throwable)throwable);
                    return;
                }
                if (counter.decrementAndGet() == 0 && !resultFuture.isDone()) {
                    resultFuture.complete(null);
                }
            }, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
        return resultFuture;
    }

    public Iterable<ReplicatedMapEntryViewHolder> entryViews(int partitionId, int fetchSize) {
        UUID iteratorId = UuidUtil.newUnsecureUUID();
        ClientMessage message = ReplicatedMapFetchEntryViewsCodec.encodeRequest(this.name, iteratorId, true, partitionId, fetchSize);
        ClientMessage responseMessage = (ClientMessage)this.invokeOnPartition(message, partitionId);
        ReplicatedMapFetchEntryViewsCodec.ResponseParameters response = ReplicatedMapFetchEntryViewsCodec.decodeResponse(responseMessage);
        return () -> new ClientReplicatedMapEntryViewIterator(this.name, partitionId, iteratorId, response.cursorId, response.entryViews, fetchSize, this.getContext());
    }

    private void registerInvalidationListener() {
        try {
            this.invalidationListenerId = this.addNearCacheInvalidationListener(new ReplicatedMapAddNearCacheEventHandler());
        }
        catch (Exception e) {
            ILogger logger = this.getContext().getLoggingService().getLogger(ClientReplicatedMapProxy.class);
            logger.severe("-----------------\nNear Cache is not initialized!\n-----------------", e);
        }
    }

    private ListenerMessageCodec createNearCacheInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddNearCacheEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, false, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddNearCacheEntryListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.invalidationListenerId != null) {
            this.getContext().getListenerService().deregisterListener(this.invalidationListenerId);
        }
    }

    public String toString() {
        return "ReplicatedMap{name='" + this.name + "'}";
    }

    private K validateKey(Object key) {
        return (K)Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
    }

    private V getCachedValue(K key) {
        if (this.nearCache == null) {
            return (V)NearCache.NOT_CACHED;
        }
        V value = this.nearCache.get(key);
        if (value == null) {
            return (V)NearCache.NOT_CACHED;
        }
        if (value == NearCache.CACHED_AS_NULL) {
            return null;
        }
        return (V)this.toObject(value);
    }

    private void tryPublishReserved(K key, V value, long reservationId) {
        if (this.nearCache == null) {
            return;
        }
        if (reservationId != -1L) {
            this.nearCache.tryPublishReserved(key, value, reservationId, false);
        }
    }

    private long tryReserveForUpdate(K key, Data keyData) {
        if (this.nearCache == null) {
            return -1L;
        }
        return this.nearCache.tryReserveForUpdate(key, keyData, NearCache.UpdateSemantic.READ_UPDATE);
    }

    private void invalidate(K key) {
        if (this.nearCache == null) {
            return;
        }
        this.nearCache.invalidate(key);
    }

    private class ReplicatedMapEventHandler
    extends AbstractReplicatedMapEventHandler {
        private ReplicatedMapAddEntryListenerCodec.AbstractEventHandler handler;

        ReplicatedMapEventHandler(EntryListener<K, V> listener) {
            super(listener);
            this.handler = new ReplicatedMapAddEntryListenerCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ReplicatedMapEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }

    private class ReplicatedMapToKeyEventHandler
    extends AbstractReplicatedMapEventHandler {
        private ReplicatedMapAddEntryListenerToKeyCodec.AbstractEventHandler handler;

        ReplicatedMapToKeyEventHandler(EntryListener<K, V> listener) {
            super(listener);
            this.handler = new ReplicatedMapAddEntryListenerToKeyCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ReplicatedMapToKeyEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }

    private class ReplicatedMapWithPredicateEventHandler
    extends AbstractReplicatedMapEventHandler {
        private ReplicatedMapAddEntryListenerWithPredicateCodec.AbstractEventHandler handler;

        ReplicatedMapWithPredicateEventHandler(EntryListener<K, V> listener) {
            super(listener);
            this.handler = new ReplicatedMapAddEntryListenerWithPredicateCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ReplicatedMapWithPredicateEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }

    private class ReplicatedMapToKeyWithPredicateEventHandler
    extends AbstractReplicatedMapEventHandler {
        private ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.AbstractEventHandler handler;

        ReplicatedMapToKeyWithPredicateEventHandler(EntryListener<K, V> listener) {
            super(listener);
            this.handler = new ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ReplicatedMapToKeyWithPredicateEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }

    private class ReplicatedMapAddNearCacheEventHandler
    extends ReplicatedMapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ReplicatedMapAddNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister(Connection connection) {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        @Override
        public void onListenerRegister(Connection connection) {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        @Override
        public void handleEntryEvent(Data dataKey, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
            EntryEventType entryEventType = EntryEventType.getByType(eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: {
                    Object key = ClientReplicatedMapProxy.this.toObject(dataKey);
                    ClientReplicatedMapProxy.this.nearCache.invalidate(key);
                    break;
                }
                case CLEAR_ALL: {
                    ClientReplicatedMapProxy.this.nearCache.clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
        }
    }

    private abstract class AbstractReplicatedMapEventHandler
    implements EventHandler<ClientMessage> {
        private final EntryListener<K, V> listener;

        AbstractReplicatedMapEventHandler(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        public void handleEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValue, int eventTypeId, UUID uuid, int numberOfAffectedEntries) {
            Member member = ClientReplicatedMapProxy.this.getContext().getClusterService().getMember(uuid);
            EntryEventType eventType = EntryEventType.getByType(eventTypeId);
            DataAwareEntryEvent entryEvent = new DataAwareEntryEvent(member, eventTypeId, ClientReplicatedMapProxy.this.name, keyData, valueData, oldValueData, null, ClientReplicatedMapProxy.this.getSerializationService());
            switch (eventType) {
                case ADDED: {
                    this.listener.entryAdded(entryEvent);
                    break;
                }
                case REMOVED: {
                    this.listener.entryRemoved(entryEvent);
                    break;
                }
                case UPDATED: {
                    this.listener.entryUpdated(entryEvent);
                    break;
                }
                case EVICTED: {
                    this.listener.entryEvicted(entryEvent);
                    break;
                }
                case CLEAR_ALL: {
                    MapEvent mapEvent = new MapEvent(ClientReplicatedMapProxy.this.getName(), member, eventTypeId, numberOfAffectedEntries);
                    this.listener.mapCleared(mapEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type: " + eventType);
                }
            }
        }
    }
}

