/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnectionManager;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class TcpClientConnection
implements ClientConnection {
    @Probe(name="connectionId", level=ProbeLevel.DEBUG)
    private final int connectionId;
    private final ILogger logger;
    private final Channel channel;
    private final TcpClientConnectionManager connectionManager;
    private final LifecycleService lifecycleService;
    private final HazelcastClientInstanceImpl client;
    private final long startTime = System.currentTimeMillis();
    private final Consumer<ClientMessage> responseHandler;
    private final ConcurrentMap attributeMap;
    @Probe(name="eventHandlerCount", level=ProbeLevel.MANDATORY)
    private final ConcurrentMap<Long, EventHandler> eventHandlerMap = new ConcurrentHashMap<Long, EventHandler>();
    @Probe(name="closedTime", level=ProbeLevel.DEBUG)
    private final AtomicLong closedTime = new AtomicLong();
    private volatile Address remoteAddress;
    private volatile Throwable closeCause;
    private volatile String closeReason;
    private volatile UUID remoteUuid;
    private volatile UUID clusterUuid;
    private volatile Channel[] tpcChannels;

    public TcpClientConnection(HazelcastClientInstanceImpl client, int connectionId, Channel channel) {
        this.client = client;
        this.responseHandler = client.getInvocationService().getResponseHandler();
        this.connectionManager = (TcpClientConnectionManager)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.channel = channel;
        this.attributeMap = channel.attributeMap();
        this.connectionId = connectionId;
        this.logger = client.getLoggingService().getLogger(TcpClientConnection.class);
        this.attributeMap.put(TcpClientConnection.class, this);
    }

    public TcpClientConnection(HazelcastClientInstanceImpl client, int connectionId) {
        this.client = client;
        this.responseHandler = client.getInvocationService().getResponseHandler();
        this.connectionManager = (TcpClientConnectionManager)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.connectionId = connectionId;
        this.channel = null;
        this.attributeMap = null;
        this.logger = client.getLoggingService().getLogger(TcpClientConnection.class);
    }

    @Override
    public ConcurrentMap attributeMap() {
        return this.attributeMap;
    }

    @Override
    public boolean write(OutboundFrame frame) {
        Channel[] tpcChannels = this.tpcChannels;
        if (tpcChannels == null) {
            return this.channel.write(frame);
        }
        ClientMessage clientMessage = (ClientMessage)frame;
        int partitionId = clientMessage.getPartitionId();
        if (partitionId < 0) {
            return this.channel.write(frame);
        }
        int channelIndex = partitionId % tpcChannels.length;
        return tpcChannels[channelIndex].write(frame);
    }

    @Override
    public void setRemoteAddress(Address remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public Address getRemoteAddress() {
        return this.remoteAddress;
    }

    public Address getInitAddress() {
        return (Address)this.attributeMap.get(Address.class);
    }

    @Override
    public UUID getRemoteUuid() {
        return this.remoteUuid;
    }

    @Override
    public void setRemoteUuid(UUID remoteUuid) {
        this.remoteUuid = remoteUuid;
    }

    @Override
    public boolean isAlive() {
        return this.closedTime.get() == 0L;
    }

    @Override
    public long lastReadTimeMillis() {
        return this.channel.lastReadTimeMillis();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.channel.lastWriteTimeMillis();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.channel.remoteSocketAddress();
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.channel.localSocketAddress();
    }

    @Override
    public void close(String reason, Throwable cause) {
        if (!this.closedTime.compareAndSet(0L, System.currentTimeMillis())) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        this.logClose();
        this.eventHandlerMap.clear();
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning("Exception while closing connection " + e.getMessage());
        }
        this.connectionManager.onConnectionClose(this);
    }

    private void logClose() {
        String message = this + " closed. Reason: ";
        message = this.closeReason != null ? message + this.closeReason : (this.closeCause != null ? message + this.closeCause.getClass().getName() + "[" + this.closeCause.getMessage() + "]" : message + "Socket explicitly closed");
        if (this.lifecycleService.isRunning()) {
            if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
                this.logger.info(message);
            } else {
                this.logger.warning(message, this.closeCause);
            }
        } else if (this.closeCause == null) {
            this.logger.finest(message);
        } else {
            this.logger.finest(message, this.closeCause);
        }
    }

    protected void innerClose() throws IOException {
        if (this.tpcChannels != null) {
            for (Channel tpcChannel : this.tpcChannels) {
                try {
                    tpcChannel.close();
                }
                catch (Exception e) {
                    this.logger.warning("Exception while closing TPC channel " + e.getMessage());
                }
            }
        }
        this.channel.close();
    }

    @Override
    public Throwable getCloseCause() {
        return this.closeCause;
    }

    @Override
    public String getCloseReason() {
        if (this.closeReason == null) {
            return this.closeCause == null ? null : this.closeCause.getMessage();
        }
        return this.closeReason;
    }

    @Override
    public void handleClientMessage(ClientMessage message) {
        if (ClientMessage.isFlagSet(message.getHeaderFlags(), 128)) {
            this.responseHandler.accept(message);
        } else if (ClientMessage.isFlagSet(message.getHeaderFlags(), 512)) {
            ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)this.client.getListenerService();
            listenerService.handleEventMessage(message);
        } else {
            this.responseHandler.accept(message);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpClientConnection)) {
            return false;
        }
        TcpClientConnection that = (TcpClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        return "ClientConnection{alive=" + this.isAlive() + ", connectionId=" + this.connectionId + ", channel=" + this.channel + ", remoteAddress=" + this.remoteAddress + ", lastReadTime=" + StringUtil.timeToStringFriendly(this.lastReadTimeMillis()) + ", lastWriteTime=" + StringUtil.timeToStringFriendly(this.lastWriteTimeMillis()) + ", closedTime=" + StringUtil.timeToStringFriendly(this.closedTime.get()) + "}";
    }

    @Override
    public EventHandler getEventHandler(long correlationId) {
        return (EventHandler)this.eventHandlerMap.get(correlationId);
    }

    @Override
    public void removeEventHandler(long correlationId) {
        this.eventHandlerMap.remove(correlationId);
    }

    @Override
    public void addEventHandler(long correlationId, EventHandler handler) {
        this.eventHandlerMap.put(correlationId, handler);
    }

    @Override
    public void setClusterUuid(UUID uuid) {
        this.clusterUuid = uuid;
    }

    @Override
    public UUID getClusterUuid() {
        return this.clusterUuid;
    }

    @Override
    public Map<Long, EventHandler> getEventHandlers() {
        return Collections.unmodifiableMap(this.eventHandlerMap);
    }

    public void setTpcChannels(Channel[] tpcChannels) {
        this.tpcChannels = tpcChannels;
    }

    @Override
    public Channel[] getTpcChannels() {
        return this.tpcChannels;
    }
}

