/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.sql.impl.expression.SearchableExpression;
import java.util.ArrayList;
import java.util.List;

public final class SearchableExpressionTracker {
    private static final ThreadLocal<List<SearchableExpression<?>>> USED_EXPRESSIONS = new ThreadLocal();

    private SearchableExpressionTracker() {
    }

    public static void startTracking() {
        assert (USED_EXPRESSIONS.get() == null);
        USED_EXPRESSIONS.set(new ArrayList());
    }

    public static List<SearchableExpression<?>> getResults() {
        return USED_EXPRESSIONS.get();
    }

    public static void stopTracking() {
        USED_EXPRESSIONS.remove();
    }

    public static void addNewSearchableExpression(SearchableExpression<?> searchableExpression) {
        List<SearchableExpression<?>> result = USED_EXPRESSIONS.get();
        if (result != null) {
            result.add(searchableExpression);
        }
    }
}

