/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlFetchCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.sql.impl.SqlInternalService;
import com.hazelcast.sql.impl.client.SqlAbstractMessageTask;
import com.hazelcast.sql.impl.client.SqlClientUtils;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlPage;
import java.security.AccessControlException;
import java.security.Permission;

public class SqlFetchMessageTask
extends SqlAbstractMessageTask<SqlFetchCodec.RequestParameters> {
    public SqlFetchMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        SqlInternalService service = this.nodeEngine.getSqlService().getInternalService();
        return service.getClientStateRegistry().fetch(((SqlFetchCodec.RequestParameters)this.parameters).queryId, ((SqlFetchCodec.RequestParameters)this.parameters).cursorBufferSize, this.serializationService);
    }

    @Override
    protected SqlFetchCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return SqlFetchCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        SqlPage page = (SqlPage)response;
        return SqlFetchCodec.encodeResponse(page, null);
    }

    @Override
    protected ClientMessage encodeException(Throwable throwable) {
        if (this.parameters == null) {
            return super.encodeException(throwable);
        }
        this.nodeEngine.getSqlService().closeOnError(((SqlFetchCodec.RequestParameters)this.parameters).queryId);
        if (throwable instanceof AccessControlException) {
            return super.encodeException(throwable);
        }
        if (!(throwable instanceof Exception)) {
            return super.encodeException(throwable);
        }
        SqlError error = SqlClientUtils.exceptionToClientError((Exception)throwable, this.nodeEngine.getLocalMember().getUuid());
        return SqlFetchCodec.encodeResponse(null, error);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:sqlService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "fetch";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((SqlFetchCodec.RequestParameters)this.parameters).queryId, ((SqlFetchCodec.RequestParameters)this.parameters).cursorBufferSize};
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

