/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Predicate;

public final class ChunkSerDeHelper {
    private final ILogger logger;
    private final int partitionId;
    private final Collection<ChunkSupplier> chunkSuppliers;
    private final int maxTotalChunkedDataInBytes;

    public ChunkSerDeHelper(ILogger logger, int partitionId, Collection<ChunkSupplier> chunkSuppliers, boolean chunkedMigrationEnabled, int maxTotalChunkedDataInBytes) {
        assert (chunkSuppliers != null);
        assert (logger != null);
        assert (!chunkedMigrationEnabled || maxTotalChunkedDataInBytes > 0) : "Found maxTotalChunkedDataInBytes=" + maxTotalChunkedDataInBytes;
        this.logger = logger;
        this.partitionId = partitionId;
        this.chunkSuppliers = chunkSuppliers;
        this.maxTotalChunkedDataInBytes = maxTotalChunkedDataInBytes;
    }

    public static Collection<Operation> readChunkedOperations(ObjectDataInput in, Collection<Operation> operations) throws IOException {
        Operation operation;
        if (in.getVersion().isUnknownOrLessThan(Versions.V5_1)) {
            return operations;
        }
        while ((operation = (Operation)in.readObject()) != null) {
            if (CollectionUtil.isEmpty(operations)) {
                operations = new LinkedList<Operation>();
            }
            operations.add(operation);
        }
        return operations;
    }

    public void writeChunkedOperations(ObjectDataOutput out) throws IOException {
        if (out.getVersion().isUnknownOrLessThan(Versions.V5_1)) {
            return;
        }
        assert (out instanceof BufferObjectDataOutput);
        BufferObjectDataOutput bufferedOut = (BufferObjectDataOutput)out;
        IsEndOfChunk isEndOfChunk = new IsEndOfChunk(this.maxTotalChunkedDataInBytes);
        for (ChunkSupplier chunkSupplier : this.chunkSuppliers) {
            Operation chunk;
            chunkSupplier.signalEndOfChunkWith(isEndOfChunk);
            while (chunkSupplier.hasNext() && (chunk = (Operation)chunkSupplier.next()) != null) {
                this.logCurrentChunk(chunkSupplier);
                out.writeObject(chunk);
                if (!isEndOfChunk.test(bufferedOut)) continue;
                break;
            }
            if (!isEndOfChunk.test(bufferedOut)) continue;
            this.logEndOfChunk(bufferedOut, isEndOfChunk);
            break;
        }
        out.writeObject(null);
        this.logEndOfAllChunks(bufferedOut, isEndOfChunk);
    }

    private void logCurrentChunk(ChunkSupplier chunkSupplier) {
        if (!this.logger.isFinestEnabled()) {
            return;
        }
        this.logger.finest(String.format("Current chunk [partitionId:%d, %s]", this.partitionId, chunkSupplier));
    }

    private void logEndOfChunk(BufferObjectDataOutput out, IsEndOfChunk isEndOfChunk) {
        if (!this.logger.isFinestEnabled()) {
            return;
        }
        this.logger.finest(String.format("Chunk is full [partitionId:%d, maxChunkSize:%s, actualChunkSize:%s]", this.partitionId, MemorySize.toPrettyString(this.maxTotalChunkedDataInBytes), MemorySize.toPrettyString(isEndOfChunk.bytesWrittenSoFar(out))));
    }

    private void logEndOfAllChunks(BufferObjectDataOutput out, IsEndOfChunk isEndOfChunk) {
        if (!this.logger.isFinestEnabled()) {
            return;
        }
        boolean allDone = true;
        for (ChunkSupplier chunkSupplier : this.chunkSuppliers) {
            if (!chunkSupplier.hasNext()) continue;
            allDone = false;
            break;
        }
        if (allDone) {
            this.logger.finest(String.format("Last chunk was sent [partitionId:%d, maxChunkSize:%s, actualChunkSize:%s]", this.partitionId, MemorySize.toPrettyString(this.maxTotalChunkedDataInBytes), MemorySize.toPrettyString(isEndOfChunk.bytesWrittenSoFar(out))));
        }
    }

    private static final class IsEndOfChunk
    implements Predicate<BufferObjectDataOutput> {
        private int positionStart;
        private boolean initialized;
        private final int maxTotalChunkedDataInBytes;

        private IsEndOfChunk(int maxTotalChunkedDataInBytes) {
            assert (maxTotalChunkedDataInBytes > 0) : "Found maxTotalChunkedDataInBytes: " + maxTotalChunkedDataInBytes;
            this.maxTotalChunkedDataInBytes = maxTotalChunkedDataInBytes;
        }

        @Override
        public boolean test(BufferObjectDataOutput out) {
            return this.bytesWrittenSoFar(out) >= this.maxTotalChunkedDataInBytes;
        }

        public int bytesWrittenSoFar(BufferObjectDataOutput out) {
            if (!this.initialized) {
                this.positionStart = out.position();
                this.initialized = true;
            }
            return out.position() - this.positionStart;
        }
    }
}

