/*
 * Decompiled with CFR 0.152.
 */
package com.harium.hci.espeak;

public class Voice {
    private String name = "default";
    private int pitch = 50;
    private int amplitude = 100;
    private int speed = 175;
    private int gap = 0;
    private String variant = "";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        if (pitch < 0 || pitch > 99) {
            throw new IllegalArgumentException("The pitch must be be between 0 and 99");
        }
        this.pitch = pitch;
    }

    public int getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(int amplitude) {
        if (amplitude < 0 || amplitude > 200) {
            throw new IllegalArgumentException("The amplitude must be be between 0 and 200");
        }
        this.amplitude = amplitude;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        if (speed < 1) {
            throw new IllegalArgumentException("The speed must be above 0");
        }
        this.speed = speed;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        if (gap < 0) {
            throw new IllegalArgumentException("The gap between words must be positive number");
        }
        this.gap = gap;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public void setVariant(boolean isMale, int index) {
        if (isMale && (index < 1 || index > 7)) {
            throw new IllegalArgumentException("The variant index for male must be between 1 and 7");
        }
        if (!(isMale || index >= 1 && index <= 5)) {
            throw new IllegalArgumentException("The variant index for female must be between 1 and 5");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(isMale ? "m" : "f");
        builder.append(index);
        this.setVariant(builder.toString());
    }

    public void setCroakVariant() {
        this.setVariant("+croak");
    }

    public void setWhisperVariant() {
        this.setVariant("+whisper");
    }

    public void removeVariant() {
        this.variant = "";
    }
}

