/*
 * Decompiled with CFR 0.152.
 */
package com.harium.hci.espeak;

import com.harium.hci.espeak.Voice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Espeak {
    public static final String COMMAND_ESPEAK = "espeak";
    private Voice voice;

    public Espeak() {
        this(new Voice());
    }

    public Espeak(Voice voice) {
        this.voice = voice;
    }

    public void speak(String text) {
        Espeak.execute(COMMAND_ESPEAK, "-v", this.buildVariant(this.voice), "-p", Integer.toString(this.voice.getPitch()), "-a", Integer.toString(this.voice.getAmplitude()), "-s", Integer.toString(this.voice.getSpeed()), "-g", Integer.toString(this.voice.getGap()), text);
    }

    private String buildVariant(Voice voice) {
        StringBuilder builder = new StringBuilder();
        if (voice.getName() != null && !voice.getName().isEmpty()) {
            builder.append(voice.getName());
        }
        if (voice.getVariant() != null && !voice.getVariant().isEmpty()) {
            builder.append("+");
            builder.append(voice.getVariant());
        }
        return builder.toString();
    }

    private static void execute(final String ... command) {
        String threadName = COMMAND_ESPEAK;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessBuilder b = new ProcessBuilder(command);
                b.redirectErrorStream(true);
                try {
                    Process process = b.start();
                    this.readErrors(process);
                    process.waitFor();
                    process.destroy();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            private void readErrors(Process process) throws IOException {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = in.readLine()) != null) {
                    System.err.println(line);
                }
            }
        }, threadName).start();
    }
}

