/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule;

import java.util.ArrayList;
import java.util.List;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModulePackage;
import proguard.resources.kotlinmodule.visitor.KotlinModulePackageVisitor;
import proguard.resources.kotlinmodule.visitor.KotlinModuleVisitor;
import proguard.util.Processable;

public class KotlinModule
extends ResourceFile
implements Processable {
    public String name;
    public final List<KotlinModulePackage> modulePackages = new ArrayList<KotlinModulePackage>();

    public KotlinModule(String fileName, long fileSize) {
        super(fileName, fileSize);
        this.name = KotlinModule.fileNameToModuleName(fileName);
    }

    public void modulePackagesAccept(KotlinModulePackageVisitor kotlinModulePackageVisitor) {
        this.modulePackages.forEach(modulePart -> kotlinModulePackageVisitor.visitKotlinModulePackage(this, (KotlinModulePackage)modulePart));
    }

    @Override
    public void accept(ResourceFileVisitor resourceFileVisitor) {
        resourceFileVisitor.visitKotlinModule(this);
    }

    public void accept(KotlinModuleVisitor kotlinModuleVisitor) {
        kotlinModuleVisitor.visitKotlinModule(this);
    }

    private static String fileNameToModuleName(String fileName) {
        return fileName.substring(fileName.indexOf(47) + 1, fileName.lastIndexOf(".kotlin_module"));
    }
}

