/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlinx.metadata.Flag;
import kotlinx.metadata.FlagsKt;
import kotlinx.metadata.KmAnnotation;
import kotlinx.metadata.KmAnnotationArgument;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmContractVisitor;
import kotlinx.metadata.KmDeclarationContainerVisitor;
import kotlinx.metadata.KmEffectExpressionVisitor;
import kotlinx.metadata.KmEffectInvocationKind;
import kotlinx.metadata.KmEffectType;
import kotlinx.metadata.KmEffectVisitor;
import kotlinx.metadata.KmFunctionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.KmTypeAliasVisitor;
import kotlinx.metadata.KmTypeParameterVisitor;
import kotlinx.metadata.KmTypeVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.KmVariance;
import kotlinx.metadata.KmVersionRequirementLevel;
import kotlinx.metadata.KmVersionRequirementVersionKind;
import kotlinx.metadata.KmVersionRequirementVisitor;
import kotlinx.metadata.jvm.JvmClassExtensionVisitor;
import kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import kotlinx.metadata.jvm.JvmDeclarationContainerExtensionVisitor;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmFlag;
import kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPackageExtensionVisitor;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeParameterExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.FieldSignature;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.kotlin.KotlinAnnotatable;
import proguard.classfile.kotlin.KotlinAnnotation;
import proguard.classfile.kotlin.KotlinAnnotationArgument;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectInvocationKind;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinEffectType;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementLevel;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementVersionKind;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinCommonFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinEffectExpressionFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinTypeAliasFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.flags.KotlinTypeParameterFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.kotlin.visitor.KotlinAnnotationArgumentVisitor;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinContractVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectExprVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.KotlinMetadataInitializer;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataWriter
implements ClassVisitor,
KotlinMetadataVisitor,
ElementValueVisitor {
    private final ClassVisitor extraClassVisitor;
    private int k;
    private int[] mv;
    private int[] bv;
    private String[] d1;
    private String[] d2;
    private int xi;
    private String xs;
    private String pn;
    private ConstantPoolEditor constantPoolEditor;
    private static ConstantPoolShrinker constantPoolShrinker = new ConstantPoolShrinker();
    private KotlinMetadataInitializer.MetadataType currentType;
    private final BiConsumer<Clazz, String> errorHandler;
    private boolean hasVisitedAny = false;

    public KotlinMetadataWriter(WarningPrinter warningPrinter) {
        this(warningPrinter, null);
    }

    public KotlinMetadataWriter(WarningPrinter warningPrinter, ClassVisitor extraClassVisitor) {
        this((Clazz clazz, String message) -> warningPrinter.print(clazz.getName(), (String)message), extraClassVisitor);
    }

    public KotlinMetadataWriter(BiConsumer<Clazz, String> errorHandler) {
        this(errorHandler, null);
    }

    public KotlinMetadataWriter(BiConsumer<Clazz, String> errorHandler, ClassVisitor extraClassVisitor) {
        this.errorHandler = errorHandler;
        this.extraClassVisitor = extraClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        clazz.kotlinMetadataAccept(this);
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        switch (kotlinMetadata.k) {
            case 1: {
                kotlinMetadata.accept(clazz, new KotlinClassConstructor());
                break;
            }
            case 2: {
                kotlinMetadata.accept(clazz, new KotlinFileFacadeConstructor());
                break;
            }
            case 3: {
                kotlinMetadata.accept(clazz, new KotlinSyntheticClassConstructor());
                break;
            }
            case 4: {
                kotlinMetadata.accept(clazz, new KotlinMultiFileFacadeConstructor());
                break;
            }
            case 5: {
                kotlinMetadata.accept(clazz, new KotlinMultiFilePartConstructor());
            }
        }
        KotlinClassMetadata md = KotlinClassMetadata.read((KotlinClassHeader)new KotlinClassHeader(Integer.valueOf(this.k), this.mv, this.bv, this.d1, this.d2, this.xs, this.pn, Integer.valueOf(this.xi)));
        if (md == null) {
            String version = this.mv == null ? "unknown" : Arrays.stream(this.mv).mapToObj(Integer::toString).collect(Collectors.joining("."));
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + " (version " + version + "). Not processing the metadata for this class.");
            return;
        }
        this.constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
        this.hasVisitedAny = false;
        try {
            clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)new AllElementValueVisitor(this))))));
        }
        catch (IllegalArgumentException e) {
            this.errorHandler.accept(clazz, "Invalid Kotlin metadata annotation for " + clazz.getName() + " (invalid Kotlin metadata field names). Not writing the metadata for this class.");
        }
        clazz.accept(constantPoolShrinker);
        if (this.extraClassVisitor != null) {
            clazz.accept(this.extraClassVisitor);
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.hasVisitedAny = true;
        this.currentType = KotlinMetadataInitializer.MetadataType.valueOf(constantElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case k: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.k);
                break;
            }
            case xi: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.xi);
                break;
            }
            case xs: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.xs);
                break;
            }
            case pn: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.pn);
            }
        }
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.hasVisitedAny = true;
        this.currentType = KotlinMetadataInitializer.MetadataType.valueOf(arrayElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case mv: {
                arrayElementValue.u2elementValuesCount = this.mv.length;
                ElementValue[] newMvElementValues = new ElementValue[this.mv.length];
                for (int k = 0; k < this.mv.length; ++k) {
                    newMvElementValues[k] = new ConstantElementValue('I', 0, this.constantPoolEditor.addIntegerConstant(this.mv[k]));
                }
                arrayElementValue.elementValues = newMvElementValues;
                break;
            }
            case bv: {
                arrayElementValue.u2elementValuesCount = this.bv.length;
                ElementValue[] newBvElementValues = new ElementValue[this.bv.length];
                for (int k = 0; k < this.bv.length; ++k) {
                    newBvElementValues[k] = new ConstantElementValue('I', 0, this.constantPoolEditor.addIntegerConstant(this.bv[k]));
                }
                arrayElementValue.elementValues = newBvElementValues;
                break;
            }
            case d1: {
                arrayElementValue.u2elementValuesCount = this.d1.length;
                ElementValue[] newD1ElementValues = new ElementValue[this.d1.length];
                for (int k = 0; k < this.d1.length; ++k) {
                    newD1ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.d1[k]));
                }
                arrayElementValue.elementValues = newD1ElementValues;
                break;
            }
            case d2: {
                arrayElementValue.u2elementValuesCount = this.d2.length;
                ElementValue[] newD2ElementValues = new ElementValue[this.d2.length];
                for (int k = 0; k < this.d2.length; ++k) {
                    newD2ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.d2[k]));
                }
                arrayElementValue.elementValues = newD2ElementValues;
            }
        }
    }

    private static JvmMethodSignature toKotlinJvmMethodSignature(MethodSignature jvmMethodSignature) {
        if (jvmMethodSignature == null) {
            return null;
        }
        return new JvmMethodSignature(jvmMethodSignature.method, jvmMethodSignature.descriptor.toString());
    }

    private static JvmFieldSignature toKotlinJvmFieldSignature(FieldSignature jvmFieldSignature) {
        if (jvmFieldSignature == null) {
            return null;
        }
        return new JvmFieldSignature(jvmFieldSignature.memberName, jvmFieldSignature.descriptor);
    }

    private static KmVersionRequirementVersionKind toKmVersionRequirementVersionKind(KotlinVersionRequirementVersionKind kotlinVersionRequirementVersionKind) {
        switch (kotlinVersionRequirementVersionKind) {
            case API_VERSION: {
                return KmVersionRequirementVersionKind.API_VERSION;
            }
            case COMPILER_VERSION: {
                return KmVersionRequirementVersionKind.COMPILER_VERSION;
            }
            case LANGUAGE_VERSION: {
                return KmVersionRequirementVersionKind.LANGUAGE_VERSION;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KotlinVersionRequirementVersionKind.");
    }

    private static KmVersionRequirementLevel toKmVersionRequirementLevel(KotlinVersionRequirementLevel kotlinVersionRequirementLevel) {
        switch (kotlinVersionRequirementLevel) {
            case ERROR: {
                return KmVersionRequirementLevel.ERROR;
            }
            case HIDDEN: {
                return KmVersionRequirementLevel.HIDDEN;
            }
            case WARNING: {
                return KmVersionRequirementLevel.WARNING;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KotlinVersionRequirementLevel.");
    }

    private static KmEffectType toKmEffectType(KotlinEffectType effectType) {
        switch (effectType) {
            case CALLS: {
                return KmEffectType.CALLS;
            }
            case RETURNS_CONSTANT: {
                return KmEffectType.RETURNS_CONSTANT;
            }
            case RETURNS_NOT_NULL: {
                return KmEffectType.RETURNS_NOT_NULL;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KotlinEffectType.");
    }

    private static KmEffectInvocationKind toKmEffectInvocationKind(KotlinEffectInvocationKind invocationKind) {
        if (invocationKind == null) {
            return null;
        }
        switch (invocationKind) {
            case AT_MOST_ONCE: {
                return KmEffectInvocationKind.AT_MOST_ONCE;
            }
            case EXACTLY_ONCE: {
                return KmEffectInvocationKind.EXACTLY_ONCE;
            }
            case AT_LEAST_ONCE: {
                return KmEffectInvocationKind.AT_LEAST_ONCE;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectInvocationKind.");
    }

    private static KmVariance toKmVariance(KotlinTypeVariance variance) {
        switch (variance) {
            case IN: {
                return KmVariance.IN;
            }
            case INVARIANT: {
                return KmVariance.INVARIANT;
            }
            case OUT: {
                return KmVariance.OUT;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVariance.");
    }

    private Set<Flag> convertCommonFlags(KotlinCommonFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.hasAnnotations) {
            flagSet.add(Flag.HAS_ANNOTATIONS);
        }
        return flagSet;
    }

    private Set<Flag> convertVisibilityFlags(KotlinVisibilityFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isInternal) {
            flagSet.add(Flag.IS_INTERNAL);
        }
        if (flags.isLocal) {
            flagSet.add(Flag.IS_LOCAL);
        }
        if (flags.isPrivate) {
            flagSet.add(Flag.IS_PRIVATE);
        }
        if (flags.isProtected) {
            flagSet.add(Flag.IS_PROTECTED);
        }
        if (flags.isPublic) {
            flagSet.add(Flag.IS_PUBLIC);
        }
        if (flags.isPrivateToThis) {
            flagSet.add(Flag.IS_PRIVATE_TO_THIS);
        }
        return flagSet;
    }

    private Set<Flag> convertModalityFlags(KotlinModalityFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isAbstract) {
            flagSet.add(Flag.IS_ABSTRACT);
        }
        if (flags.isFinal) {
            flagSet.add(Flag.IS_FINAL);
        }
        if (flags.isOpen) {
            flagSet.add(Flag.IS_OPEN);
        }
        if (flags.isSealed) {
            flagSet.add(Flag.IS_SEALED);
        }
        return flagSet;
    }

    private int convertFunctionFlags(KotlinFunctionFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(this.convertModalityFlags(flags.modality));
        if (flags.isDeclaration) {
            flagSet.add(Flag.Function.IS_DECLARATION);
        }
        if (flags.isFakeOverride) {
            flagSet.add(Flag.Function.IS_FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            flagSet.add(Flag.Function.IS_DELEGATION);
        }
        if (flags.isSynthesized) {
            flagSet.add(Flag.Function.IS_SYNTHESIZED);
        }
        if (flags.isOperator) {
            flagSet.add(Flag.Function.IS_OPERATOR);
        }
        if (flags.isInfix) {
            flagSet.add(Flag.Function.IS_INFIX);
        }
        if (flags.isInline) {
            flagSet.add(Flag.Function.IS_INLINE);
        }
        if (flags.isTailrec) {
            flagSet.add(Flag.Function.IS_TAILREC);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.Function.IS_EXTERNAL);
        }
        if (flags.isSuspend) {
            flagSet.add(Flag.Function.IS_SUSPEND);
        }
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    private int convertTypeFlags(KotlinTypeFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        if (flags.isNullable) {
            flagSet.add(Flag.Type.IS_NULLABLE);
        }
        if (flags.isSuspend) {
            flagSet.add(Flag.Type.IS_SUSPEND);
        }
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    private int convertTypeParameterFlags(KotlinTypeParameterFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        if (flags.isReified) {
            flagSet.add(Flag.TypeParameter.IS_REIFIED);
        }
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    private int convertTypeAliasFlags(KotlinTypeAliasFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    private int convertPropertyFlags(KotlinPropertyFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(this.convertModalityFlags(flags.modality));
        if (flags.isDeclared) {
            flagSet.add(Flag.Property.IS_DECLARATION);
        }
        if (flags.isFakeOverride) {
            flagSet.add(Flag.Property.IS_FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            flagSet.add(Flag.Property.IS_DELEGATION);
        }
        if (flags.isSynthesized) {
            flagSet.add(Flag.Property.IS_SYNTHESIZED);
        }
        if (flags.isVar) {
            flagSet.add(Flag.Property.IS_VAR);
        }
        if (flags.hasGetter) {
            flagSet.add(Flag.Property.HAS_GETTER);
        }
        if (flags.hasSetter) {
            flagSet.add(Flag.Property.HAS_SETTER);
        }
        if (flags.isConst) {
            flagSet.add(Flag.Property.IS_CONST);
        }
        if (flags.isLateinit) {
            flagSet.add(Flag.Property.IS_LATEINIT);
        }
        if (flags.hasConstant) {
            flagSet.add(Flag.Property.HAS_CONSTANT);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.Property.IS_EXTERNAL);
        }
        if (flags.isDelegated) {
            flagSet.add(Flag.Property.IS_DELEGATED);
        }
        if (flags.isExpect) {
            flagSet.add(Flag.Property.IS_EXPECT);
        }
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    private int convertPropertyJvmFlags(KotlinPropertyFlags flags) {
        return flags.isMovedFromInterfaceCompanion ? FlagsKt.flagsOf((Flag[])new Flag[]{JvmFlag.Property.IS_MOVED_FROM_INTERFACE_COMPANION}) : 0;
    }

    private int convertPropertyAccessorFlags(KotlinPropertyAccessorFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(this.convertModalityFlags(flags.modality));
        if (!flags.isDefault) {
            flagSet.add(Flag.PropertyAccessor.IS_NOT_DEFAULT);
        }
        if (flags.isInline) {
            flagSet.add(Flag.PropertyAccessor.IS_INLINE);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.PropertyAccessor.IS_EXTERNAL);
        }
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    private int convertValueParameterFlags(KotlinValueParameterFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        if (flags.hasDefaultValue) {
            flagSet.add(Flag.ValueParameter.DECLARES_DEFAULT_VALUE);
        }
        if (flags.isNoInline) {
            flagSet.add(Flag.ValueParameter.IS_NOINLINE);
        }
        if (flags.isCrossInline) {
            flagSet.add(Flag.ValueParameter.IS_CROSSINLINE);
        }
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    private int convertEffectExpressionFlags(KotlinEffectExpressionFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isNullCheckPredicate) {
            flagSet.add(Flag.EffectExpression.IS_NULL_CHECK_PREDICATE);
        }
        if (flags.isNegated) {
            flagSet.add(Flag.EffectExpression.IS_NEGATED);
        }
        return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
    }

    static /* synthetic */ int[] access$1402(KotlinMetadataWriter x0, int[] x1) {
        x0.mv = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1502(KotlinMetadataWriter x0, int[] x1) {
        x0.bv = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1602(KotlinMetadataWriter x0, String[] x1) {
        x0.d1 = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1702(KotlinMetadataWriter x0, String[] x1) {
        x0.d2 = x1;
        return x1;
    }

    private static class AnnotationArgumentConstructor
    implements KotlinAnnotationArgumentVisitor {
        private final BiConsumer<String, KmAnnotationArgument<?>> consumer;

        public AnnotationArgumentConstructor(BiConsumer<String, KmAnnotationArgument<?>> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void visitAnyArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.Value value) {
        }

        @Override
        public void visitByteArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.ByteValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.ByteValue(((Byte)value.value).byteValue()));
        }

        @Override
        public void visitCharArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.CharValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.CharValue(((Character)value.value).charValue()));
        }

        @Override
        public void visitShortArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.ShortValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.ShortValue(((Short)value.value).shortValue()));
        }

        @Override
        public void visitIntArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.IntValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.IntValue(((Integer)value.value).intValue()));
        }

        @Override
        public void visitLongArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.LongValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.LongValue(((Long)value.value).longValue()));
        }

        @Override
        public void visitFloatArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.FloatValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.FloatValue(((Float)value.value).floatValue()));
        }

        @Override
        public void visitDoubleArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.DoubleValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.DoubleValue(((Double)value.value).doubleValue()));
        }

        @Override
        public void visitBooleanArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.BooleanValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.BooleanValue(((Boolean)value.value).booleanValue()));
        }

        @Override
        public void visitUByteArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.UByteValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.UByteValue(((Byte)value.value).byteValue()));
        }

        @Override
        public void visitUShortArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.UShortValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.UShortValue(((Short)value.value).shortValue()));
        }

        @Override
        public void visitUIntArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.UIntValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.UIntValue(((Integer)value.value).intValue()));
        }

        @Override
        public void visitULongArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.ULongValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.ULongValue(((Long)value.value).longValue()));
        }

        @Override
        public void visitStringArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.StringValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.StringValue((String)value.value));
        }

        @Override
        public void visitClassArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.ClassValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.KClassValue(value.className));
        }

        @Override
        public void visitEnumArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.EnumValue value) {
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.EnumValue(value.className, value.enumEntryName));
        }

        @Override
        public void visitAnnotationArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.AnnotationValue value) {
            value.annotationAccept(clazz, annotatable, new AnnotationConstructor(kmAnnotation -> this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.AnnotationValue(kmAnnotation))));
        }

        @Override
        public void visitArrayArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.ArrayValue value) {
            ArrayList elements = new ArrayList();
            value.elementsAccept(clazz, annotatable, annotation, argument, new AnnotationArgumentConstructor((__, element) -> elements.add(element)));
            this.consumer.accept(argument.name, (KmAnnotationArgument<?>)new KmAnnotationArgument.ArrayValue(elements));
        }
    }

    private static class AnnotationConstructor
    implements KotlinAnnotationVisitor {
        private final Consumer<KmAnnotation> consumer;

        public AnnotationConstructor(Consumer<KmAnnotation> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void visitAnyAnnotation(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation) {
            HashMap arguments = new HashMap();
            annotation.argumentsAccept(clazz, annotatable, new AnnotationArgumentConstructor(arguments::put));
            this.consumer.accept(new KmAnnotation(annotation.className, arguments));
        }
    }

    private class VersionRequirementConstructor
    implements KotlinVersionRequirementVisitor {
        private KmVersionRequirementVisitor versionReqVis;
        private KmConstructorVisitor constructorVis;
        private KmClassVisitor classVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;
        private KmTypeAliasVisitor aliasVis;

        VersionRequirementConstructor(KmConstructorVisitor constructorVis) {
            this.constructorVis = constructorVis;
        }

        VersionRequirementConstructor(KmClassVisitor classVis) {
            this.classVis = classVis;
        }

        VersionRequirementConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        VersionRequirementConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        VersionRequirementConstructor(KmTypeAliasVisitor aliasVis) {
            this.aliasVis = aliasVis;
        }

        @Override
        public void visitClassVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.classVis.visitVersionRequirement();
        }

        @Override
        public void visitConstructorVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.constructorVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitPropertyVersionRequirement(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.propertyVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitFunctionVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.functionVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitTypeAliasVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.aliasVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis.visit(KotlinMetadataWriter.toKmVersionRequirementVersionKind(kotlinVersionRequirementMetadata.kind), KotlinMetadataWriter.toKmVersionRequirementLevel(kotlinVersionRequirementMetadata.level), kotlinVersionRequirementMetadata.errorCode, kotlinVersionRequirementMetadata.message);
            this.versionReqVis.visitVersion(kotlinVersionRequirementMetadata.major, kotlinVersionRequirementMetadata.minor, kotlinVersionRequirementMetadata.patch);
            this.versionReqVis.visitEnd();
        }
    }

    private class KotlinMultiFilePartConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private final KotlinClassMetadata.MultiFileClassPart.Writer multiPartKmdWriter;

        KotlinMultiFilePartConstructor() {
            this(new KotlinClassMetadata.MultiFileClassPart.Writer());
        }

        private KotlinMultiFilePartConstructor(KotlinClassMetadata.MultiFileClassPart.Writer multiPartKmdWriter) {
            super((KmDeclarationContainerVisitor)multiPartKmdWriter);
            this.multiPartKmdWriter = multiPartKmdWriter;
        }

        @Override
        public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
            kotlinMultiFilePartKindMetadata.propertiesAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.functionsAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.typeAliasesAccept(clazz, this);
            JvmPackageExtensionVisitor ext = (JvmPackageExtensionVisitor)this.multiPartKmdWriter.visitExtensions(JvmPackageExtensionVisitor.TYPE);
            this.extensionVisitor = ext;
            kotlinMultiFilePartKindMetadata.delegatedPropertiesAccept(clazz, this);
            ext.visitEnd();
            this.multiPartKmdWriter.visitEnd();
            KotlinClassHeader header = this.multiPartKmdWriter.write(kotlinMultiFilePartKindMetadata.facadeName, KotlinClassHeader.COMPATIBLE_METADATA_VERSION, kotlinMultiFilePartKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1602(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }
    }

    private class KotlinMultiFileFacadeConstructor
    implements KotlinMetadataVisitor {
        private KotlinMultiFileFacadeConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
            KotlinClassHeader header = new KotlinClassMetadata.MultiFileClassFacade.Writer().write(kotlinMultiFileFacadeKindMetadata.partClassNames, KotlinClassHeader.COMPATIBLE_METADATA_VERSION, kotlinMultiFileFacadeKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1602(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }
    }

    private class KotlinSyntheticClassConstructor
    implements KotlinMetadataVisitor,
    KotlinFunctionVisitor {
        private KotlinSyntheticClassKindMetadata md;
        private final KotlinClassMetadata.SyntheticClass.Writer kmdWriter = new KotlinClassMetadata.SyntheticClass.Writer();

        KotlinSyntheticClassConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            this.md = kotlinSyntheticClassKindMetadata;
            this.md.functionsAccept(clazz, this);
            this.kmdWriter.visitEnd();
            KotlinClassHeader header = this.kmdWriter.write(KotlinClassHeader.COMPATIBLE_METADATA_VERSION, kotlinSyntheticClassKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1602(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunctionVisitor kmdFunctionVisitor = this.kmdWriter.visitFunction(KotlinMetadataWriter.this.convertFunctionFlags(kotlinFunctionMetadata.flags), kotlinFunctionMetadata.name);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new ValueParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinSyntheticClassKindMetadata, new VersionRequirementConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinSyntheticClassKindMetadata, new ContractConstructor(kmdFunctionVisitor));
            JvmFunctionExtensionVisitor ext = (JvmFunctionExtensionVisitor)kmdFunctionVisitor.visitExtensions(JvmFunctionExtensionVisitor.TYPE);
            JvmMethodSignature jvmMethodSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinFunctionMetadata.jvmSignature);
            ext.visit(jvmMethodSignature);
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                ext.visitLambdaClassOriginName(kotlinFunctionMetadata.lambdaClassOriginName);
            }
            ext.visitEnd();
            kmdFunctionVisitor.visitEnd();
        }
    }

    private class KotlinFileFacadeConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private final KotlinClassMetadata.FileFacade.Writer facadeKmdWriter;

        KotlinFileFacadeConstructor() {
            this(new KotlinClassMetadata.FileFacade.Writer());
        }

        private KotlinFileFacadeConstructor(KotlinClassMetadata.FileFacade.Writer facadeKmdWriter) {
            super((KmDeclarationContainerVisitor)facadeKmdWriter);
            this.facadeKmdWriter = facadeKmdWriter;
        }

        @Override
        public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
            kotlinFileFacadeKindMetadata.propertiesAccept(clazz, this);
            kotlinFileFacadeKindMetadata.functionsAccept(clazz, this);
            kotlinFileFacadeKindMetadata.typeAliasesAccept(clazz, this);
            JvmPackageExtensionVisitor ext = (JvmPackageExtensionVisitor)this.kmdWriter.visitExtensions(JvmPackageExtensionVisitor.TYPE);
            this.extensionVisitor = ext;
            kotlinFileFacadeKindMetadata.delegatedPropertiesAccept(clazz, this);
            ext.visitEnd();
            this.facadeKmdWriter.visitEnd();
            KotlinClassHeader header = this.facadeKmdWriter.write(KotlinClassHeader.COMPATIBLE_METADATA_VERSION, kotlinFileFacadeKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1602(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }
    }

    private class TypeParameterConstructor
    implements KotlinTypeParameterVisitor {
        private KmTypeParameterVisitor typeParamVis;
        private KmClassVisitor classVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;
        private KmTypeAliasVisitor aliasVis;

        TypeParameterConstructor(KmClassVisitor classVis) {
            this.classVis = classVis;
        }

        TypeParameterConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        TypeParameterConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        TypeParameterConstructor(KmTypeAliasVisitor aliasVis) {
            this.aliasVis = aliasVis;
        }

        @Override
        public void visitClassTypeParameter(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.classVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitPropertyTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.propertyVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitFunctionTypeParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.functionVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitAliasTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.aliasVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            kotlinTypeParameterMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.typeParamVis));
            JvmTypeParameterExtensionVisitor typeParamExtVis = (JvmTypeParameterExtensionVisitor)this.typeParamVis.visitExtensions(JvmTypeParameterExtensionVisitor.TYPE);
            kotlinTypeParameterMetadata.annotationsAccept(clazz, new AnnotationConstructor(arg_0 -> ((JvmTypeParameterExtensionVisitor)typeParamExtVis).visitAnnotation(arg_0)));
            typeParamExtVis.visitEnd();
            this.typeParamVis.visitEnd();
        }
    }

    private class TypeConstructor
    implements KotlinTypeVisitor {
        private KmTypeVisitor typeVis;
        private KmTypeVisitor nestedTypeVis;
        private KmValueParameterVisitor valParamVis;
        private KmClassVisitor classVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;
        private KmTypeAliasVisitor aliasVis;
        private KmTypeParameterVisitor typeParamVis;
        private KmEffectExpressionVisitor effectExpressionVis;

        TypeConstructor(KmTypeVisitor nestedTypeVis) {
            this.nestedTypeVis = nestedTypeVis;
        }

        TypeConstructor(KmValueParameterVisitor valParamVis) {
            this.valParamVis = valParamVis;
        }

        TypeConstructor(KmClassVisitor classVis) {
            this.classVis = classVis;
        }

        TypeConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        TypeConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        TypeConstructor(KmTypeAliasVisitor aliasVis) {
            this.aliasVis = aliasVis;
        }

        TypeConstructor(KmTypeParameterVisitor typeParamVis) {
            this.typeParamVis = typeParamVis;
        }

        TypeConstructor(KmEffectExpressionVisitor effectExpressionVis) {
            this.effectExpressionVis = effectExpressionVis;
        }

        @Override
        public void visitTypeUpperBound(Clazz clazz, KotlinTypeMetadata boundedType, KotlinTypeMetadata upperBound) {
            this.typeVis = this.nestedTypeVis.visitFlexibleTypeUpperBound(KotlinMetadataWriter.this.convertTypeFlags(boundedType.flags), upperBound.flexibilityID);
            this.visitAnyType(clazz, upperBound);
        }

        @Override
        public void visitAbbreviation(Clazz clazz, KotlinTypeMetadata abbreviatedType, KotlinTypeMetadata abbreviation) {
            this.typeVis = this.nestedTypeVis.visitAbbreviatedType(KotlinMetadataWriter.this.convertTypeFlags(abbreviatedType.flags));
            this.visitAnyType(clazz, abbreviation);
        }

        @Override
        public void visitParameterUpperBound(Clazz clazz, KotlinTypeParameterMetadata boundedTypeParameter, KotlinTypeMetadata upperBound) {
            this.typeVis = this.typeParamVis.visitUpperBound(KotlinMetadataWriter.this.convertTypeFlags(upperBound.flags));
            this.visitAnyType(clazz, upperBound);
        }

        @Override
        public void visitTypeOfIsExpression(Clazz clazz, KotlinEffectExpressionMetadata kotlinEffectExprMetadata, KotlinTypeMetadata typeOfIs) {
            this.typeVis = this.effectExpressionVis.visitIsInstanceType(KotlinMetadataWriter.this.convertTypeFlags(typeOfIs.flags));
            this.visitAnyType(clazz, typeOfIs);
        }

        @Override
        public void visitTypeArgument(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinTypeMetadata typeArgument) {
            this.typeVis = this.nestedTypeVis.visitArgument(KotlinMetadataWriter.this.convertTypeFlags(typeArgument.flags), KotlinMetadataWriter.toKmVariance(typeArgument.variance));
            this.visitAnyType(clazz, typeArgument);
        }

        @Override
        public void visitStarProjection(Clazz clazz, KotlinTypeMetadata typeWithStarArg) {
            this.nestedTypeVis.visitStarProjection();
        }

        @Override
        public void visitOuterClass(Clazz clazz, KotlinTypeMetadata innerClass, KotlinTypeMetadata outerClass) {
            this.typeVis = this.nestedTypeVis.visitOuterType(KotlinMetadataWriter.this.convertTypeFlags(outerClass.flags));
            this.visitAnyType(clazz, outerClass);
        }

        @Override
        public void visitConstructorValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitConstructorValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitSuperType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.classVis.visitSupertype(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.propertyVis.visitReturnType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyReceiverType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.propertyVis.visitReceiverParameterType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitVarargElementType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionReturnType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.functionVis.visitReturnType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.functionVis.visitReceiverParameterType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionValParamType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionValParamVarArgType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitVarargElementType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitAliasUnderlyingType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.aliasVis.visitUnderlyingType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitAliasExpandedType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.aliasVis.visitExpandedType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            if (kotlinTypeMetadata.className != null) {
                String className = kotlinTypeMetadata.className.replace('$', '.');
                this.typeVis.visitClass(className);
            }
            if (kotlinTypeMetadata.typeParamID >= 0) {
                this.typeVis.visitTypeParameter(kotlinTypeMetadata.typeParamID);
            }
            if (kotlinTypeMetadata.aliasName != null) {
                this.typeVis.visitTypeAlias(kotlinTypeMetadata.aliasName);
            }
            kotlinTypeMetadata.abbreviationAccept(clazz, new TypeConstructor(this.typeVis));
            kotlinTypeMetadata.outerClassAccept(clazz, new TypeConstructor(this.typeVis));
            kotlinTypeMetadata.typeArgumentsAccept(clazz, new TypeConstructor(this.typeVis));
            kotlinTypeMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.typeVis));
            JvmTypeExtensionVisitor typeExtVis = (JvmTypeExtensionVisitor)this.typeVis.visitExtensions(JvmTypeExtensionVisitor.TYPE);
            typeExtVis.visit(kotlinTypeMetadata.isRaw);
            kotlinTypeMetadata.annotationsAccept(clazz, new AnnotationConstructor(arg_0 -> ((JvmTypeExtensionVisitor)typeExtVis).visitAnnotation(arg_0)));
            typeExtVis.visitEnd();
            this.typeVis.visitEnd();
        }
    }

    private class ValueParameterConstructor
    implements KotlinValueParameterVisitor {
        private KmValueParameterVisitor valParamVis;
        private KmConstructorVisitor constructorVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;

        ValueParameterConstructor(KmConstructorVisitor constructorVis) {
            this.constructorVis = constructorVis;
        }

        ValueParameterConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        ValueParameterConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        @Override
        public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        }

        @Override
        public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.valParamVis = this.constructorVis.visitValueParameter(KotlinMetadataWriter.this.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)new TypeConstructor(this.valParamVis));
            this.valParamVis.visitEnd();
        }

        @Override
        public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.valParamVis = this.propertyVis.visitSetterParameter(KotlinMetadataWriter.this.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)new TypeConstructor(this.valParamVis));
            this.valParamVis.visitEnd();
        }

        @Override
        public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.valParamVis = this.functionVis.visitValueParameter(KotlinMetadataWriter.this.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)new TypeConstructor(this.valParamVis));
            this.valParamVis.visitEnd();
        }
    }

    private class KotlinClassConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor,
    KotlinConstructorVisitor {
        KotlinClassMetadata.Class.Writer classKmdWriter;

        KotlinClassConstructor() {
            this(new KotlinClassMetadata.Class.Writer());
        }

        private KotlinClassConstructor(KotlinClassMetadata.Class.Writer classKmdWriter) {
            super((KmDeclarationContainerVisitor)classKmdWriter);
            this.classKmdWriter = classKmdWriter;
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            this.classKmdWriter.visit(this.convertClassFlags(kotlinClassKindMetadata.flags), kotlinClassKindMetadata.className.replace('$', '.'));
            if (kotlinClassKindMetadata.companionObjectName != null) {
                this.classKmdWriter.visitCompanionObject(kotlinClassKindMetadata.companionObjectName);
            }
            kotlinClassKindMetadata.propertiesAccept(clazz, this);
            kotlinClassKindMetadata.functionsAccept(clazz, this);
            kotlinClassKindMetadata.typeAliasesAccept(clazz, this);
            for (String enumEntry : kotlinClassKindMetadata.enumEntryNames) {
                this.classKmdWriter.visitEnumEntry(enumEntry);
            }
            for (String nestedClass : kotlinClassKindMetadata.nestedClassNames) {
                this.classKmdWriter.visitNestedClass(nestedClass);
            }
            for (String sealedSubClass : kotlinClassKindMetadata.sealedSubclassNames) {
                this.classKmdWriter.visitSealedSubclass(sealedSubClass.replace('$', '.'));
            }
            kotlinClassKindMetadata.constructorsAccept(clazz, this);
            kotlinClassKindMetadata.superTypesAccept(clazz, new TypeConstructor((KmClassVisitor)this.classKmdWriter));
            kotlinClassKindMetadata.typeParametersAccept(clazz, new TypeParameterConstructor((KmClassVisitor)this.classKmdWriter));
            kotlinClassKindMetadata.versionRequirementAccept(clazz, new VersionRequirementConstructor((KmClassVisitor)this.classKmdWriter));
            JvmClassExtensionVisitor ext = (JvmClassExtensionVisitor)this.classKmdWriter.visitExtensions(JvmClassExtensionVisitor.TYPE);
            this.extensionVisitor = ext;
            kotlinClassKindMetadata.delegatedPropertiesAccept(clazz, this);
            if (kotlinClassKindMetadata.anonymousObjectOriginName != null) {
                ext.visitAnonymousObjectOriginName(kotlinClassKindMetadata.anonymousObjectOriginName);
            }
            ext.visitEnd();
            this.classKmdWriter.visitEnd();
            KotlinClassHeader header = this.classKmdWriter.write(KotlinClassHeader.COMPATIBLE_METADATA_VERSION, kotlinClassKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1602(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }

        @Override
        public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
            KmConstructorVisitor constructorVis = this.classKmdWriter.visitConstructor(this.convertConstructorFlags(kotlinConstructorMetadata.flags));
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, new ValueParameterConstructor(constructorVis));
            kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, new VersionRequirementConstructor(constructorVis));
            if (kotlinConstructorMetadata.jvmSignature != null) {
                JvmConstructorExtensionVisitor constExtVis = (JvmConstructorExtensionVisitor)constructorVis.visitExtensions(JvmConstructorExtensionVisitor.TYPE);
                JvmMethodSignature jvmMethodSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinConstructorMetadata.jvmSignature);
                constExtVis.visit(jvmMethodSignature);
            }
            constructorVis.visitEnd();
        }

        private int convertClassFlags(KotlinClassFlags flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            flagSet.addAll(KotlinMetadataWriter.this.convertCommonFlags(flags.common));
            flagSet.addAll(KotlinMetadataWriter.this.convertVisibilityFlags(flags.visibility));
            flagSet.addAll(KotlinMetadataWriter.this.convertModalityFlags(flags.modality));
            if (flags.isUsualClass) {
                flagSet.add(Flag.Class.IS_CLASS);
            }
            if (flags.isInterface) {
                flagSet.add(Flag.Class.IS_INTERFACE);
            }
            if (flags.isEnumClass) {
                flagSet.add(Flag.Class.IS_ENUM_CLASS);
            }
            if (flags.isEnumEntry) {
                flagSet.add(Flag.Class.IS_ENUM_ENTRY);
            }
            if (flags.isAnnotationClass) {
                flagSet.add(Flag.Class.IS_ANNOTATION_CLASS);
            }
            if (flags.isObject) {
                flagSet.add(Flag.Class.IS_OBJECT);
            }
            if (flags.isCompanionObject) {
                flagSet.add(Flag.Class.IS_COMPANION_OBJECT);
            }
            if (flags.isInner) {
                flagSet.add(Flag.Class.IS_INNER);
            }
            if (flags.isData) {
                flagSet.add(Flag.Class.IS_DATA);
            }
            if (flags.isExternal) {
                flagSet.add(Flag.Class.IS_EXTERNAL);
            }
            if (flags.isExpect) {
                flagSet.add(Flag.Class.IS_EXPECT);
            }
            if (flags.isInline) {
                flagSet.add(Flag.Class.IS_INLINE);
            }
            if (flags.isFun) {
                flagSet.add(Flag.Class.IS_FUN);
            }
            return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
        }

        private int convertConstructorFlags(KotlinConstructorFlags flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            flagSet.addAll(KotlinMetadataWriter.this.convertCommonFlags(flags.common));
            flagSet.addAll(KotlinMetadataWriter.this.convertVisibilityFlags(flags.visibility));
            if (flags.isPrimary) {
                flagSet.add(Flag.Constructor.IS_PRIMARY);
            }
            if (flags.isSecondary) {
                flagSet.add(Flag.Constructor.IS_SECONDARY);
            }
            if (flags.hasNonStableParameterNames) {
                flagSet.add(Flag.Constructor.HAS_NON_STABLE_PARAMETER_NAMES);
            }
            return FlagsKt.flagsOf((Flag[])flagSet.toArray(new Flag[0]));
        }
    }

    private class KotlinDeclarationContainerConstructor
    implements KotlinPropertyVisitor,
    KotlinFunctionVisitor,
    KotlinTypeAliasVisitor {
        KmDeclarationContainerVisitor kmdWriter;
        KmPropertyVisitor kmdPropertyVisitor;
        JvmDeclarationContainerExtensionVisitor extensionVisitor;

        KotlinDeclarationContainerConstructor(KmDeclarationContainerVisitor classKmdWriter) {
            this.kmdWriter = classKmdWriter;
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(this.kmdPropertyVisitor));
            JvmPropertyExtensionVisitor ext = (JvmPropertyExtensionVisitor)this.kmdPropertyVisitor.visitExtensions(JvmPropertyExtensionVisitor.TYPE);
            JvmMethodSignature getterSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.getterSignature);
            JvmMethodSignature setterSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.setterSignature);
            JvmFieldSignature backingFieldSignature = KotlinMetadataWriter.toKotlinJvmFieldSignature(kotlinPropertyMetadata.backingFieldSignature);
            ext.visit(KotlinMetadataWriter.this.convertPropertyJvmFlags(kotlinPropertyMetadata.flags), backingFieldSignature, getterSignature, setterSignature);
            if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
                ext.visitSyntheticMethodForAnnotations(KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.syntheticMethodForAnnotations));
            }
            ext.visitEnd();
            this.kmdPropertyVisitor.visitEnd();
        }

        @Override
        public void visitProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmdPropertyVisitor = this.kmdWriter.visitProperty(KotlinMetadataWriter.this.convertPropertyFlags(kotlinPropertyMetadata.flags), kotlinPropertyMetadata.name, KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.getterFlags), KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.setterFlags));
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
        }

        @Override
        public void visitDelegatedProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmdPropertyVisitor = this.extensionVisitor.visitLocalDelegatedProperty(KotlinMetadataWriter.this.convertPropertyFlags(kotlinPropertyMetadata.flags), kotlinPropertyMetadata.name, KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.getterFlags), KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.setterFlags));
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunctionVisitor kmdFunctionVisitor = this.kmdWriter.visitFunction(KotlinMetadataWriter.this.convertFunctionFlags(kotlinFunctionMetadata.flags), kotlinFunctionMetadata.name);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinDeclarationContainerMetadata, new ContractConstructor(kmdFunctionVisitor));
            JvmFunctionExtensionVisitor ext = (JvmFunctionExtensionVisitor)kmdFunctionVisitor.visitExtensions(JvmFunctionExtensionVisitor.TYPE);
            JvmMethodSignature jvmMethodSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinFunctionMetadata.jvmSignature);
            ext.visit(jvmMethodSignature);
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                ext.visitLambdaClassOriginName(kotlinFunctionMetadata.lambdaClassOriginName);
            }
            ext.visitEnd();
            kmdFunctionVisitor.visitEnd();
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            KmTypeAliasVisitor kmdAliasVisitor = this.kmdWriter.visitTypeAlias(KotlinMetadataWriter.this.convertTypeAliasFlags(kotlinTypeAliasMetadata.flags), kotlinTypeAliasMetadata.name);
            kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmdAliasVisitor));
            kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdAliasVisitor));
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdAliasVisitor));
            kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmdAliasVisitor));
            kotlinTypeAliasMetadata.annotationsAccept(clazz, new AnnotationConstructor(arg_0 -> ((KmTypeAliasVisitor)kmdAliasVisitor).visitAnnotation(arg_0)));
            kmdAliasVisitor.visitEnd();
        }

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }
    }

    private class EffectExprConstructor
    implements KotlinEffectExprVisitor {
        private KmEffectExpressionVisitor effectExprVis;
        private KmEffectVisitor effectVis;
        private KmEffectExpressionVisitor nestedExprVis;

        private EffectExprConstructor(KmEffectVisitor effectVis) {
            this.effectVis = effectVis;
        }

        private EffectExprConstructor(KmEffectExpressionVisitor nestedExprVis) {
            this.nestedExprVis = nestedExprVis;
        }

        @Override
        public void visitAnyEffectExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.effectExprVis.visit(KotlinMetadataWriter.this.convertEffectExpressionFlags(kotlinEffectExpressionMetadata.flags), Integer.valueOf(kotlinEffectExpressionMetadata.parameterIndex));
            if (kotlinEffectExpressionMetadata.hasConstantValue) {
                this.effectExprVis.visitConstantValue(kotlinEffectExpressionMetadata.constantValue);
            }
            kotlinEffectExpressionMetadata.andRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.effectExprVis));
            kotlinEffectExpressionMetadata.orRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.effectExprVis));
            kotlinEffectExpressionMetadata.typeOfIsAccept(clazz, new TypeConstructor(this.effectExprVis));
            this.effectExprVis.visitEnd();
        }

        @Override
        public void visitAndRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.effectExprVis = this.nestedExprVis.visitAndArgument();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
        }

        @Override
        public void visitOrRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.effectExprVis = this.nestedExprVis.visitOrArgument();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
        }

        @Override
        public void visitConstructorArgExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.effectExprVis = this.effectVis.visitConstructorArgument();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
        }

        @Override
        public void visitConclusionExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.effectExprVis = this.effectVis.visitConclusionOfConditionalEffect();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
        }
    }

    private class EffectConstructor
    implements KotlinEffectVisitor {
        private final KmContractVisitor kmContractVisitor;

        private EffectConstructor(KmContractVisitor kmContractVisitor) {
            this.kmContractVisitor = kmContractVisitor;
        }

        @Override
        public void visitEffect(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata, KotlinEffectMetadata kotlinEffectMetadata) {
            KmEffectVisitor kmEffectVisitor = this.kmContractVisitor.visitEffect(KotlinMetadataWriter.toKmEffectType(kotlinEffectMetadata.effectType), KotlinMetadataWriter.toKmEffectInvocationKind(kotlinEffectMetadata.invocationKind));
            kotlinEffectMetadata.conclusionOfConditionalEffectAccept(clazz, new EffectExprConstructor(kmEffectVisitor));
            kotlinEffectMetadata.constructorArgumentAccept(clazz, new EffectExprConstructor(kmEffectVisitor));
            kmEffectVisitor.visitEnd();
        }
    }

    private class ContractConstructor
    implements KotlinContractVisitor {
        private KmFunctionVisitor kmdFunctionVisitor;

        ContractConstructor(KmFunctionVisitor kmdFunctionVisitor) {
            this.kmdFunctionVisitor = kmdFunctionVisitor;
        }

        @Override
        public void visitContract(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata) {
            KmContractVisitor kmContractVisitor = this.kmdFunctionVisitor.visitContract();
            kotlinContractMetadata.effectsAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, new EffectConstructor(kmContractVisitor));
            kmContractVisitor.visitEnd();
        }
    }
}

