/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.ExceptionsAllowedToRetry;
import com.google.maps.internal.GaePendingResult;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaeRequestHandler
implements GeoApiContext.RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)GaeRequestHandler.class.getName());
    private final URLFetchService client = URLFetchServiceFactory.getURLFetchService();

    GaeRequestHandler() {
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handle(String hostName, String url, String userAgent, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry) {
        HTTPRequest req;
        FetchOptions fetchOptions = FetchOptions.Builder.withDeadline((double)10.0);
        try {
            req = new HTTPRequest(new URL(hostName + url), HTTPMethod.POST, fetchOptions);
        }
        catch (MalformedURLException e) {
            LOG.error("Request: {}{}", new Object[]{hostName, url, e});
            throw new RuntimeException(e);
        }
        return new GaePendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry);
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handlePost(String hostName, String url, String payload, String userAgent, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry) {
        FetchOptions fetchOptions = FetchOptions.Builder.withDeadline((double)10.0);
        HTTPRequest req = null;
        try {
            req = new HTTPRequest(new URL(hostName + url), HTTPMethod.POST, fetchOptions);
            req.setHeader(new HTTPHeader("Content-Type", "application/json; charset=utf-8"));
            req.setPayload(payload.getBytes(StandardCharsets.UTF_8));
        }
        catch (MalformedURLException e) {
            LOG.error("Request: {}{}", new Object[]{hostName, url, e});
            throw new RuntimeException(e);
        }
        return new GaePendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry);
    }

    @Override
    public void shutdown() {
    }

    public static class Builder
    implements GeoApiContext.RequestHandler.Builder {
        @Override
        public Builder connectTimeout(long timeout, TimeUnit unit) {
            throw new RuntimeException("connectTimeout not implemented for Google App Engine");
        }

        @Override
        public Builder readTimeout(long timeout, TimeUnit unit) {
            throw new RuntimeException("readTimeout not implemented for Google App Engine");
        }

        @Override
        public Builder writeTimeout(long timeout, TimeUnit unit) {
            throw new RuntimeException("writeTimeout not implemented for Google App Engine");
        }

        @Override
        public Builder queriesPerSecond(int maxQps) {
            throw new RuntimeException("queriesPerSecond not implemented for Google App Engine");
        }

        @Override
        public Builder proxy(Proxy proxy) {
            throw new RuntimeException("setProxy not implemented for Google App Engine");
        }

        @Override
        public Builder proxyAuthentication(String proxyUserName, String proxyUserPassword) {
            throw new RuntimeException("setProxyAuthentication not implemented for Google App Engine");
        }

        @Override
        public GeoApiContext.RequestHandler build() {
            return new GaeRequestHandler();
        }
    }
}

