/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultisetElementSetTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testElementSetReflectsAddAbsent() {
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertFalse((boolean)elementSet.contains(this.e3()));
        this.getMultiset().add(this.e3(), 4);
        MultisetElementSetTester.assertTrue((boolean)elementSet.contains(this.e3()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetReflectsRemove() {
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertTrue((boolean)elementSet.contains(this.e0()));
        this.getMultiset().removeAll(Collections.singleton(this.e0()));
        MultisetElementSetTester.assertFalse((boolean)elementSet.contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetRemovePropagatesToMultiset() {
        Set elementSet = this.getMultiset().elementSet();
        int size = this.getNumElements();
        int expectedSize = size - this.getMultiset().count(this.e0());
        MultisetElementSetTester.assertTrue((boolean)elementSet.remove(this.e0()));
        MultisetElementSetTester.assertFalse((boolean)this.getMultiset().contains(this.e0()));
        MultisetElementSetTester.assertEquals((int)expectedSize, (int)this.getMultiset().size());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetRemoveDuplicatePropagatesToMultiset() {
        this.initThreeCopies();
        int size = this.getNumElements();
        int expectedSize = size - this.getMultiset().count(this.e0());
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertTrue((boolean)elementSet.remove(this.e0()));
        Helpers.assertEmpty(this.getMultiset());
        MultisetElementSetTester.assertEquals((int)expectedSize, (int)this.getMultiset().size());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetRemoveAbsent() {
        Set elementSet = this.getMultiset().elementSet();
        MultisetElementSetTester.assertFalse((boolean)elementSet.remove(this.e3()));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testElementSetClear() {
        this.getMultiset().elementSet().clear();
        Helpers.assertEmpty(this.getMultiset());
    }

    @GwtIncompatible
    public static List<Method> getElementSetDuplicateInitializingMethods() {
        return Arrays.asList(Helpers.getMethod(MultisetElementSetTester.class, "testElementSetRemoveDuplicatePropagatesToMultiset"));
    }
}

