/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapPutIterableTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyIterableOnPresentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Lists.newArrayList((Object[])new Object[]{MultimapPutIterableTester.this.v3(), MultimapPutIterableTester.this.v4()}).iterator();
            }
        }));
        this.assertGet(this.k0(), this.v0(), this.v3(), this.v4());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyCollectionOnPresentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        this.assertGet(this.k0(), this.v0(), this.v3(), this.v4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyIterableOnAbsentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k3(), new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return Lists.newArrayList((Object[])new Object[]{MultimapPutIterableTester.this.v3(), MultimapPutIterableTester.this.v4()}).iterator();
            }
        }));
        this.assertGet(this.k3(), this.v3(), this.v4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllNonEmptyCollectionOnAbsentKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        this.assertGet(this.k3(), this.v3(), this.v4());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueOnPresentKey_supported() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), null})));
        this.assertGet(this.k0(), this.v0(), this.v3(), null);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueOnAbsentKey_supported() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), null})));
        this.assertGet(this.k3(), this.v3(), null);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueSingle_unsupported() {
        this.multimap().putAll(this.k1(), (Iterable)Lists.newArrayList((Object[])new Object[]{null}));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueNullLast_unsupported() {
        int size = this.getNumElements();
        try {
            this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), null}));
            MultimapPutIterableTester.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Collection values = this.multimap().get(this.k3());
        if (values.size() == 0) {
            this.expectUnchanged();
            MultimapPutIterableTester.assertEquals((Object)Lists.newArrayList(), (Object)Lists.newArrayList((Iterable)values));
            MultimapPutIterableTester.assertEquals((int)size, (int)this.multimap().size());
        } else {
            MultimapPutIterableTester.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{this.v3()}), (Object)Lists.newArrayList((Iterable)values));
            MultimapPutIterableTester.assertEquals((int)(size + 1), (int)this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllNullValueNullFirst_unsupported() {
        int size = this.getNumElements();
        try {
            this.multimap().putAll(this.k3(), (Iterable)Lists.newArrayList((Object[])new Object[]{null, this.v3()}));
            MultimapPutIterableTester.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        MultimapPutIterableTester.assertEquals((Object)Lists.newArrayList(), (Object)Lists.newArrayList((Iterable)this.multimap().get(this.k3())));
        MultimapPutIterableTester.assertEquals((int)size, (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllOnPresentNullKey() {
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(null, (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        this.assertGet(null, this.v3(), this.v4());
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllNullForbidden() {
        try {
            this.multimap().putAll(null, Collections.singletonList(this.v3()));
            MultimapPutIterableTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyCollectionOnAbsentKey() {
        MultimapPutIterableTester.assertFalse((boolean)this.multimap().putAll(this.k3(), Collections.emptyList()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnAbsentKey() {
        Iterable iterable = new Iterable<V>(this){

            @Override
            public Iterator<V> iterator() {
                return ImmutableSet.of().iterator();
            }
        };
        MultimapPutIterableTester.assertFalse((boolean)this.multimap().putAll(this.k3(), iterable));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllEmptyIterableOnPresentKey() {
        this.multimap().putAll(this.k0(), Collections.emptyList());
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllOnlyCallsIteratorOnce() {
        Iterable iterable = new Iterable<V>(){
            private boolean calledIteratorAlready = false;

            @Override
            public Iterator<V> iterator() {
                Preconditions.checkState((!this.calledIteratorAlready ? 1 : 0) != 0);
                this.calledIteratorAlready = true;
                return Iterators.forArray((Object[])new Object[]{MultimapPutIterableTester.this.v3()});
            }
        };
        this.multimap().putAll(this.k3(), iterable);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllPropagatesToGet() {
        Collection getCollection = this.multimap().get(this.k0());
        int getCollectionSize = getCollection.size();
        MultimapPutIterableTester.assertTrue((boolean)this.multimap().putAll(this.k0(), (Iterable)Lists.newArrayList((Object[])new Object[]{this.v3(), this.v4()})));
        MultimapPutIterableTester.assertEquals((int)(getCollectionSize + 2), (int)getCollection.size());
        Helpers.assertContainsAllOf(getCollection, this.v3(), this.v4());
    }
}

