/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.icons.AwareIconStyle;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.swingdsl.DarklafComponentFactory;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import javax.swing.UIDefaults;

public class UtilityDefaultsInitTask
implements DefaultsInitTask {
    @Override
    public void run(Theme currentTheme, UIDefaults defaults) {
        this.setupUtils(currentTheme, defaults);
    }

    private void setupUtils(Theme currentTheme, UIDefaults defaults) {
        PaintUtil.setDropOpacity(this.getOpacity(defaults, "dropOpacity"));
        PaintUtil.setGlowOpacity(this.getOpacity(defaults, "glowOpacity"));
        PaintUtil.setShadowOpacity(this.getOpacity(defaults, "shadowOpacityLight"));
        PaintUtil.setErrorGlow(defaults.getColor("glowError"));
        PaintUtil.setErrorFocusGlow(defaults.getColor("glowFocusError"));
        PaintUtil.setFocusGlow(defaults.getColor("glowFocus"));
        PaintUtil.setFocusInactiveGlow(defaults.getColor("glowFocusInactive"));
        PaintUtil.setWarningGlow(defaults.getColor("glowWarning"));
        CellUtil.updateColors(defaults);
        IconLoader.updateAwareStyle((AwareIconStyle)(Theme.isDark((Theme)currentTheme) ? AwareIconStyle.DARK : AwareIconStyle.LIGHT));
        IconLoader.updateThemeStatus((Object)new Object());
        IconLoader.reloadFrameIcons();
        defaults.put("swingdsl.componentFactoryProvider", DarklafComponentFactory::new);
    }

    private float getOpacity(UIDefaults defaults, String key) {
        Object obj = defaults.get(key);
        int val = obj instanceof Integer ? (Integer)obj : 100;
        return (float)val / 100.0f;
    }

    @Override
    public boolean onlyDuringInstallation() {
        return true;
    }
}

