/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

class CSSBuilder {
    private final StringBuilder b = new StringBuilder();
    private boolean groupOpen = false;

    CSSBuilder() {
    }

    public CSSGroup group(String name) {
        return this.nextGroup(name);
    }

    private CSSBuilder closeGroup() {
        if (this.groupOpen) {
            this.b.append("}");
            this.groupOpen = false;
        }
        return this;
    }

    private CSSGroup nextGroup(String name) {
        this.closeGroup();
        this.b.append(name).append(" {");
        this.groupOpen = true;
        return new CSSGroup(this);
    }

    private void addProperty(String key, String value) {
        this.b.append(key).append(":").append(value).append(";");
    }

    public String toString() {
        return this.b.toString();
    }

    protected static class CSSGroup {
        protected final CSSBuilder builder;

        public CSSGroup(CSSBuilder builder) {
            this.builder = builder;
        }

        public CSSBuilder end() {
            return this.builder.closeGroup();
        }

        public CSSGroup group(String name) {
            return this.builder.nextGroup(name);
        }

        public CSSGroup property(String key, Object value) {
            this.builder.addProperty(key, value.toString());
            return this;
        }

        public CSSGroup color(String value) {
            return this.property("color", value);
        }

        public CSSGroup border(Object value) {
            return this.property("border", value);
        }

        public CSSGroup borderColor(String value) {
            return this.property("border-color", value);
        }

        public CSSGroup borderStyle(String value) {
            return this.property("border-style", value);
        }

        public CSSGroup borderWidth(String value) {
            return this.property("border-width", value);
        }

        public CSSGroup padding(Object value) {
            return this.property("padding", value);
        }

        public CSSGroup borderCollapse(String value) {
            return this.property("border-collapse", value);
        }

        public CSSGroup fontSize(Object value) {
            return this.property("font-size", value);
        }

        public CSSGroup fontWeight(String value) {
            return this.property("font-weight", value);
        }

        public CSSGroup fontStyle(String value) {
            return this.property("font-style", value);
        }

        public CSSGroup textDecoration(String value) {
            return this.property("text-decoration", value);
        }

        public CSSGroup fontFamily(String family, String name) {
            return this.property("font-family", family + ", " + name);
        }

        public CSSGroup marginTop(Object value) {
            return this.property("margin-top", value);
        }

        public CSSGroup marginBottom(Object value) {
            return this.property("margin-bottom", value);
        }

        public CSSGroup marginLeft(Object value) {
            return this.property("margin-left", value);
        }

        public CSSGroup marginRight(Object value) {
            return this.property("margin-right", value);
        }

        public CSSGroup marginLeftLTR(Object value) {
            return this.property("margin-left-ltr", value);
        }

        public CSSGroup marginRightRTL(Object value) {
            return this.property("margin-right-rtl", value);
        }

        public CSSGroup listStyleType(String value) {
            return this.property("list-style-type", value);
        }

        public CSSGroup margin(Object value) {
            return this.property("margin", value);
        }
    }
}

