/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http.okhttp;

import com.wechat.pay.java.core.http.Constant;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpMultiDomainInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpMultiDomainInterceptor.class);

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.shouldRetry(request)) {
            try {
                return chain.proceed(request);
            }
            catch (IOException e) {
                logger.warn("Retrying request due to connectivity failure: {}", (Object)e.getMessage(), (Object)e);
                Request retryRequest = this.modifyRequestForRetry(request);
                return chain.proceed(retryRequest);
            }
        }
        return chain.proceed(request);
    }

    private boolean shouldRetry(Request request) {
        return Constant.PRIMARY_API_DOMAIN.contains(request.url().host());
    }

    private Request modifyRequestForRetry(Request originalRequest) {
        HttpUrl.Builder urlBuilder = originalRequest.url().newBuilder();
        urlBuilder.host("api2.wechatpay.cn");
        Request.Builder reqBuilder = originalRequest.newBuilder();
        reqBuilder.url(urlBuilder.build());
        reqBuilder.header("User-Agent", originalRequest.header("User-Agent") + " (Retried-V1)");
        return reqBuilder.build();
    }
}

