// Copyright 2021 Tencent Inc. All rights reserved.
//
// 电商退款API
//
// 境内电商退款功能相关API文档
//
// API version: 1.1.8

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommercerefund.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.function.UnaryOperator;

/** CreateAbnormalRefundRequest */
public class CreateAbnormalRefundRequest {
  /** 二级商户号 说明：微信支付分配二级商户的商户号 */
  @SerializedName("sub_mchid")
  private String subMchid;
  /** 商户退款单号 说明：商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。 */
  @SerializedName("out_refund_no")
  private String outRefundNo;
  /** 异常退款处理方式 说明：可选：退款至用户、退款至交易商户银行账户 */
  @SerializedName("type")
  private Type type;
  /**
   * 开户银行
   * 说明：银行类型，采用字符串类型的银行标识，值列表详见[银行类型](https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_2)。仅支持招行、交通银行、农行、建行、工商、中行、平安、浦发、中信、光大、民生、兴业、广发、邮储、宁波银行的借记卡。
   * 若退款至用户此字段必填。
   */
  @SerializedName("bank_type")
  private String bankType;
  /**
   * 收款银行卡号
   * 说明：用户的银行卡账号，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://wechatpay-api.gitbook.io/wechatpay-api-v3/qian-ming-zhi-nan-1/min-gan-xin-xi-jia-mi)。
   * 若退款至用户此字段必填。
   */
  @Encryption
  @SerializedName("bank_account")
  private String bankAccount;
  /**
   * 收款用户姓名
   * 说明：收款用户姓名，该字段需进行加密处理，加密方法详见[敏感信息加密说明](https://wechatpay-api.gitbook.io/wechatpay-api-v3/qian-ming-zhi-nan-1/min-gan-xin-xi-jia-mi)。
   * 若退款至用户此字段必填。
   */
  @Encryption
  @SerializedName("real_name")
  private String realName;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getOutRefundNo() {
    return outRefundNo;
  }

  public void setOutRefundNo(String outRefundNo) {
    this.outRefundNo = outRefundNo;
  }

  public Type getType() {
    return type;
  }

  public void setType(Type type) {
    this.type = type;
  }

  public String getBankType() {
    return bankType;
  }

  public void setBankType(String bankType) {
    this.bankType = bankType;
  }

  public String getBankAccount() {
    return bankAccount;
  }

  public void setBankAccount(String bankAccount) {
    this.bankAccount = bankAccount;
  }

  public String getRealName() {
    return realName;
  }

  public void setRealName(String realName) {
    this.realName = realName;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateAbnormalRefundRequest {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    outRefundNo: ").append(toIndentedString(outRefundNo)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    bankType: ").append(toIndentedString(bankType)).append("\n");
    sb.append("    bankAccount: ").append(toIndentedString(bankAccount)).append("\n");
    sb.append("    realName: ").append(toIndentedString(realName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public CreateAbnormalRefundRequest cloneWithCipher(UnaryOperator<String> s) {
    CreateAbnormalRefundRequest copy = new CreateAbnormalRefundRequest();
    copy.subMchid = subMchid;
    copy.outRefundNo = outRefundNo;
    copy.type = type;
    copy.bankType = bankType;
    if (bankAccount != null && !bankAccount.isEmpty()) {
      copy.bankAccount = s.apply(bankAccount);
    }
    if (realName != null && !realName.isEmpty()) {
      copy.realName = s.apply(realName);
    }
    return copy;
  }
}
