/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.rockridge.impl;

import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.EmptyByteArrayDataReference;
import com.github.stephenc.javaisotools.rockridge.impl.SystemUseEntryElement;
import com.github.stephenc.javaisotools.rockridge.impl.SystemUseEntryHandler;
import com.github.stephenc.javaisotools.sabre.ContentHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.StructureHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;
import java.util.HashMap;

public class SUSPFactory {
    public static final int CE_ENTRY_LENGTH = 28;
    StreamHandler streamHandler;

    public SUSPFactory(StreamHandler streamHandler) {
        this.streamHandler = new SystemUseEntryHandler((StructureHandler)streamHandler, (ContentHandler)streamHandler);
    }

    public HashMap doCEEntry() throws HandlerException {
        HashMap<String, Fixup> memory = new HashMap<String, Fixup>();
        this.streamHandler.startElement((Element)new SystemUseEntryElement("CE", 1));
        Fixup ceLocationFixup = this.streamHandler.fixup((DataReference)new BothWordDataReference(0L));
        memory.put("ceLocationFixup", ceLocationFixup);
        Fixup ceOffsetFixup = this.streamHandler.fixup((DataReference)new BothWordDataReference(0L));
        memory.put("ceOffsetFixup", ceOffsetFixup);
        Fixup ceLengthFixup = this.streamHandler.fixup((DataReference)new BothWordDataReference(0L));
        memory.put("ceLengthFixup", ceLengthFixup);
        this.streamHandler.endElement();
        return memory;
    }

    public void doPDEntry(int paddingLength) throws HandlerException {
        this.streamHandler.startElement((Element)new SystemUseEntryElement("PD", 1));
        this.streamHandler.data((DataReference)new EmptyByteArrayDataReference(paddingLength));
        this.streamHandler.endElement();
    }

    public void doSPEntry(int skipBytes) throws HandlerException {
        this.streamHandler.startElement((Element)new SystemUseEntryElement("SP", 1));
        this.streamHandler.data((DataReference)new ByteDataReference(190L));
        this.streamHandler.data((DataReference)new ByteDataReference(239L));
        this.streamHandler.data((DataReference)new ByteDataReference((long)skipBytes));
        this.streamHandler.endElement();
    }

    public void doSTEntry() throws HandlerException {
        this.streamHandler.startElement((Element)new SystemUseEntryElement("ST", 1));
        this.streamHandler.endElement();
    }

    public void doEREntry(DataReference id, DataReference descriptor, DataReference source, int version) throws HandlerException {
        this.streamHandler.startElement((Element)new SystemUseEntryElement("ER", 1));
        this.streamHandler.data((DataReference)new ByteDataReference(id.getLength()));
        this.streamHandler.data((DataReference)new ByteDataReference(descriptor.getLength()));
        this.streamHandler.data((DataReference)new ByteDataReference(source.getLength()));
        this.streamHandler.data((DataReference)new ByteDataReference((long)version));
        this.streamHandler.data(id);
        if (descriptor.getLength() > 0L) {
            this.streamHandler.data(descriptor);
        }
        this.streamHandler.data(source);
        this.streamHandler.endElement();
    }

    public void doEREntry(DataReference id, DataReference source, int version) throws HandlerException {
        this.doEREntry(id, new EmptyByteArrayDataReference(0), source, version);
    }

    public void doESEntry(int sequenceNumber) throws HandlerException {
        this.streamHandler.startElement((Element)new SystemUseEntryElement("ES", 1));
        this.streamHandler.data((DataReference)new ByteDataReference((long)sequenceNumber));
        this.streamHandler.endElement();
    }
}

