/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.rockridge.impl;

import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.rockridge.impl.RRIPFactory;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeNamingConventions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RockRidgeConfig {
    private Map<String, Integer> patternToModeMap = new HashMap<String, Integer>();

    public void setMkisofsCompatibility(boolean flag) {
        RRIPFactory.MKISOFS_COMPATIBILITY = flag;
    }

    public void setMaxDirectoryLength(int length) throws ConfigException {
        if (length < 0) {
            throw new ConfigException(this, "Invalid maximum directory length: " + length);
        }
        RockRidgeNamingConventions.MAX_DIRECTORY_LENGTH = length;
    }

    public void setMaxFilenameLength(int length) throws ConfigException {
        if (length < 0) {
            throw new ConfigException(this, "Invalid maximum directory length: " + length);
        }
        RockRidgeNamingConventions.MAX_FILENAME_LENGTH = length;
    }

    public void forcePortableFilenameCharacterSet(boolean flag) {
        RockRidgeNamingConventions.FORCE_PORTABLE_FILENAME_CHARACTER_SET = flag;
    }

    public void hideMovedDirectoriesStore(boolean flag) {
        RockRidgeNamingConventions.HIDE_MOVED_DIRECTORIES_STORE = flag;
    }

    public void addModeForPattern(String pattern, Integer mode) {
        System.out.println(String.format("*** Recording pattern \"%s\" with mode %o", pattern, mode));
        this.patternToModeMap.put(pattern, mode);
    }

    public Map<String, Integer> getPatternToModeMap() {
        return Collections.unmodifiableMap(this.patternToModeMap);
    }
}

