/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.volumedescriptors;

import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.PartitionConfig;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.iso9660.volumedescriptors.ISO9660VolumeDescriptor;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;
import java.util.HashMap;

public class VolumePartitionDescriptor
extends ISO9660VolumeDescriptor {
    private String systemId = "";
    private String volumePartitionId = "";

    public VolumePartitionDescriptor(StreamHandler streamHandler, LayoutHelper helper) {
        super(streamHandler, 3, helper);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setVolumePartitionId(String volumePartitionId) {
        this.volumePartitionId = volumePartitionId;
    }

    public void setMetadata(PartitionConfig config) {
        this.setSystemId(config.getSystemId());
        this.setVolumePartitionId(config.getVolumePartitionId());
    }

    public HashMap doVPD() throws HandlerException {
        HashMap<String, Fixup> memory = new HashMap<String, Fixup>();
        this.streamHandler.data((DataReference)this.getType());
        this.streamHandler.data((DataReference)this.getStandardId());
        this.streamHandler.data((DataReference)this.getVDVersion());
        this.streamHandler.data((DataReference)new ByteDataReference(0L));
        this.streamHandler.data((DataReference)this.getSystemId());
        this.streamHandler.data((DataReference)this.getVolumePartitionId());
        Fixup location = this.streamHandler.fixup((DataReference)new BothWordDataReference(0L));
        memory.put("volumePartitionLocationFixup", location);
        Fixup size = this.streamHandler.fixup((DataReference)new BothWordDataReference(0L));
        memory.put("volumePartitionSizeFixup", size);
        return memory;
    }

    private ByteArrayDataReference getSystemId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.systemId, 32);
        return new ByteArrayDataReference(bytes);
    }

    private ByteArrayDataReference getVolumePartitionId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.volumePartitionId, 32);
        return new ByteArrayDataReference(bytes);
    }
}

