/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.iso9660.FilenameDataReference;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660FilenameDataReference;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660NamingConventions;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.io.UnsupportedEncodingException;

public class ISO9660LayoutHelper
extends LayoutHelper {
    public ISO9660LayoutHelper(StreamHandler streamHandler, ISO9660RootDirectory root) {
        super(streamHandler, root, new ISO9660NamingConventions());
    }

    @Override
    public FilenameDataReference getFilenameDataReference(ISO9660Directory dir) throws HandlerException {
        return new ISO9660FilenameDataReference(dir);
    }

    @Override
    public FilenameDataReference getFilenameDataReference(ISO9660File file) throws HandlerException {
        return new ISO9660FilenameDataReference(file);
    }

    @Override
    public byte[] pad(String string, int targetByteLength) throws HandlerException {
        byte[] bytes = new byte[targetByteLength];
        byte[] original = null;
        int length = 0;
        try {
            int i;
            if (string != null) {
                original = string.getBytes("ISO-8859-1");
                length = original.length;
            }
            for (i = 0; i < length; ++i) {
                bytes[i] = original[i];
            }
            for (i = length; i < bytes.length; ++i) {
                bytes[i] = 32;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return bytes;
    }
}

