/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660;

import com.github.stephenc.javaisotools.iso9660.ISO9660DirectoryIterator;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660HierarchyObject;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ISO9660Directory
implements ISO9660HierarchyObject {
    private String name;
    private int level;
    private List<ISO9660File> files;
    private List<ISO9660Directory> directories;
    private ISO9660Directory parent;
    private ISO9660RootDirectory root;
    private long lastModified;
    private boolean sorted;
    private Object id;
    ISO9660DirectoryIterator sortedIterator;
    ISO9660DirectoryIterator unsortedIterator;

    public ISO9660Directory(String name) {
        this.init();
        this.name = name;
    }

    public ISO9660Directory(File file) throws HandlerException {
        this.init();
        if (!file.isDirectory()) {
            throw new HandlerException("Not a directory: " + file);
        }
        this.name = file.getName();
        this.lastModified = file.lastModified();
    }

    private void init() {
        this.files = new ArrayList<ISO9660File>();
        this.directories = new ArrayList<ISO9660Directory>();
        this.level = 1;
        this.parent = this;
        this.name = "";
        this.lastModified = new Date().getTime();
        this.sorted = false;
        this.id = new Object();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.parent != this) {
            this.parent.forceSort();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    void setRoot(ISO9660RootDirectory root) {
        this.root = root;
    }

    @Override
    public ISO9660RootDirectory getRoot() {
        return this.root;
    }

    @Override
    public ISO9660Directory getParentDirectory() {
        return this.parent;
    }

    void setParentDirectory(ISO9660Directory parent) {
        this.parent = parent;
    }

    public List<ISO9660File> getFiles() {
        if (!this.sorted) {
            this.sort();
        }
        return this.files;
    }

    public List<ISO9660Directory> getDirectories() {
        if (!this.sorted) {
            this.sort();
        }
        return this.directories;
    }

    public boolean hasSubDirs() {
        return this.directories.size() > 0;
    }

    @Override
    public String getISOPath() {
        StringBuffer buf = new StringBuffer();
        this.getISOPath(buf);
        return buf.toString();
    }

    private void getISOPath(StringBuffer buf) {
        ISO9660Directory parent = this.getParentDirectory();
        if (parent == this) {
            return;
        }
        parent.getISOPath(buf);
        buf.append(File.separator);
        buf.append(this.getName());
    }

    int deepLevelCount() {
        int count = this.level;
        for (ISO9660Directory dir : this.directories) {
            count = Math.max(count, dir.deepLevelCount());
        }
        return count;
    }

    int deepFileCount() {
        int count = this.files.size();
        for (ISO9660Directory dir : this.directories) {
            count += dir.deepFileCount();
        }
        return count;
    }

    int deepDirCount() {
        int count = this.directories.size();
        for (ISO9660Directory dir : this.directories) {
            count += dir.deepDirCount();
        }
        return count;
    }

    public ISO9660Directory addDirectory(ISO9660Directory dir) {
        dir.setLevel(this.level + 1);
        dir.setParentDirectory(this);
        dir.setRoot(this.root);
        this.updateSubdirectories(dir);
        this.directories.add(dir);
        this.sorted = false;
        return dir;
    }

    private void updateSubdirectories(ISO9660Directory dir) {
        List<ISO9660Directory> subdirectories = dir.getDirectories();
        for (ISO9660Directory subdir : subdirectories) {
            subdir.setLevel(dir.getLevel() + 1);
            subdir.setRoot(dir.getRoot());
            this.updateSubdirectories(subdir);
        }
    }

    public ISO9660Directory addDirectory(File file) throws HandlerException {
        ISO9660Directory dir = new ISO9660Directory(file);
        return this.addDirectory(dir);
    }

    public ISO9660Directory addDirectory(String name) {
        ISO9660Directory dir = new ISO9660Directory(name);
        return this.addDirectory(dir);
    }

    public ISO9660Directory addPath(String path) throws HandlerException {
        if (path.indexOf(File.separator) == -1) {
            return this.checkDirectory(path);
        }
        int frontSeparatorIndex = path.indexOf(File.separator);
        String dirName = path.substring(0, frontSeparatorIndex);
        ISO9660Directory dir = this.checkDirectory(dirName);
        String rest = path.substring(frontSeparatorIndex + 1);
        dir = dir.addPath(rest);
        return dir;
    }

    private ISO9660Directory checkDirectory(String name) throws HandlerException {
        for (ISO9660Directory dir : this.directories) {
            if (!dir.getName().equals(name)) continue;
            return dir;
        }
        return this.addDirectory(name);
    }

    public void forceSort() {
        this.sorted = false;
    }

    private void sort() {
        Collections.sort(this.files);
        Collections.sort(this.directories);
        this.sorted = true;
    }

    public void addFile(ISO9660File file) {
        file.setParentDirectory(this);
        this.files.add(file);
        this.sorted = false;
    }

    public void addFile(File file, int version) throws HandlerException {
        this.addFile(new ISO9660File(file, version));
    }

    public void addFile(File file) throws HandlerException {
        this.addFile(new ISO9660File(file));
    }

    public void addFile(String pathname, int version) throws HandlerException {
        this.addFile(new ISO9660File(pathname, version));
    }

    public void addFile(String pathname) throws HandlerException {
        this.addFile(new ISO9660File(pathname));
    }

    public void addRecursively(File file) throws HandlerException {
        this.addRecursively(file, true, this);
    }

    public void addContentsRecursively(File file) throws HandlerException {
        this.addRecursively(file, false, this);
    }

    private void addRecursively(File file, boolean addItself, ISO9660Directory parent) throws HandlerException {
        if (!file.isDirectory() && addItself) {
            parent.addFile(file);
            return;
        }
        ISO9660Directory dir = parent;
        if (addItself) {
            dir = parent.addDirectory(file);
        }
        for (File childFile : file.listFiles()) {
            this.addRecursively(childFile, true, dir);
        }
    }

    public int compareTo(Object object) throws ClassCastException, NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object.equals(this)) {
            return 0;
        }
        if (object instanceof ISO9660Directory) {
            ISO9660Directory dir = (ISO9660Directory)object;
            return this.getName().toUpperCase().compareTo(dir.getName().toUpperCase());
        }
        if (object instanceof ISO9660File) {
            ISO9660File file = (ISO9660File)object;
            return this.getName().toUpperCase().compareTo(file.getFullName().toUpperCase());
        }
        throw new ClassCastException();
    }

    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    public boolean isMoved() {
        return this.parent == this.root.getMovedDirectoriesStore();
    }

    public ISO9660Directory relocate() {
        ISO9660Directory movedDirectoriesStore = this.root.getMovedDirectoriesStore();
        ISO9660Directory oldParent = this.parent;
        int oldLevel = this.level;
        movedDirectoriesStore.addDirectory(this);
        int difference = oldLevel - this.getLevel();
        Iterator<ISO9660Directory> it = this.unsortedIterator();
        while (it.hasNext()) {
            ISO9660Directory subdir = it.next();
            subdir.setLevel(subdir.getLevel() - difference);
        }
        return oldParent;
    }

    @Override
    public Object getID() {
        return this.id;
    }

    public Object clone() {
        ISO9660Directory clone = null;
        try {
            clone = (ISO9660Directory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.level = this.level;
        clone.directories = new ArrayList<ISO9660Directory>();
        clone.files = new ArrayList<ISO9660File>();
        clone.id = this.id;
        clone.sortedIterator = null;
        clone.sorted = false;
        for (ISO9660Directory subdir : this.directories) {
            ISO9660Directory subdirClone = (ISO9660Directory)subdir.clone();
            subdirClone.setParentDirectory(clone);
            subdirClone.setLevel(this.level + 1);
            subdirClone.id = subdir.id;
            subdirClone.sortedIterator = null;
            subdirClone.sorted = false;
            clone.directories.add(subdirClone);
        }
        for (ISO9660File file : this.files) {
            ISO9660File fileClone = (ISO9660File)file.clone();
            fileClone.setParentDirectory(clone);
            clone.files.add(fileClone);
        }
        return clone;
    }

    public Iterator<ISO9660Directory> sortedIterator() {
        if (this.sortedIterator == null) {
            this.sortedIterator = new ISO9660DirectoryIterator(this, true);
        }
        this.sortedIterator.reset();
        return this.sortedIterator;
    }

    public Iterator<ISO9660Directory> unsortedIterator() {
        if (this.unsortedIterator == null) {
            this.unsortedIterator = new ISO9660DirectoryIterator(this, false);
        }
        this.unsortedIterator.reset();
        return this.unsortedIterator;
    }
}

