/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.hibernate;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.transaction.TransactionObjectHolder;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.ConfigHelper;
import org.snaker.engine.helper.StringHelper;

public abstract class HibernateHelper {
    private static final Logger log = LoggerFactory.getLogger(HibernateHelper.class);
    private static SessionFactory sessionFactory;

    private static void initialize() {
        String driver = ConfigHelper.getProperty((String)"jdbc.driver");
        String url = ConfigHelper.getProperty((String)"jdbc.url");
        String username = ConfigHelper.getProperty((String)"jdbc.username");
        String password = ConfigHelper.getProperty((String)"jdbc.password");
        String dialect = ConfigHelper.getProperty((String)"hibernate.dialect");
        AssertHelper.notNull((Object)driver);
        AssertHelper.notNull((Object)url);
        AssertHelper.notNull((Object)username);
        AssertHelper.notNull((Object)password);
        AssertHelper.notNull((Object)dialect);
        String formatSql = ConfigHelper.getProperty((String)"hibernate.format_sql");
        String showSql = ConfigHelper.getProperty((String)"hibernate.show_sql");
        Configuration configuration = new Configuration();
        if (StringHelper.isNotEmpty((String)driver)) {
            configuration.setProperty("hibernate.connection.driver_class", driver);
        }
        if (StringHelper.isNotEmpty((String)url)) {
            configuration.setProperty("hibernate.connection.url", url);
        }
        if (StringHelper.isNotEmpty((String)username)) {
            configuration.setProperty("hibernate.connection.username", username);
        }
        if (StringHelper.isNotEmpty((String)password)) {
            configuration.setProperty("hibernate.connection.password", password);
        }
        if (StringHelper.isNotEmpty((String)dialect)) {
            configuration.setProperty("hibernate.dialect", dialect);
        }
        if (StringHelper.isNotEmpty((String)formatSql)) {
            configuration.setProperty("hibernate.format_sql", formatSql);
        }
        if (StringHelper.isNotEmpty((String)showSql)) {
            configuration.setProperty("hibernate.show_sql", showSql);
        }
        sessionFactory = configuration.configure().buildSessionFactory();
    }

    public static Session getSession(SessionFactory sf) {
        Session session = (Session)TransactionObjectHolder.get();
        if (session == null) {
            if (sf != null) {
                return sf.getCurrentSession();
            }
            if (log.isDebugEnabled()) {
                log.debug("could not found sessionFactory.");
            }
            return HibernateHelper.getSessionFactory().openSession();
        }
        if (log.isDebugEnabled()) {
            log.debug("found thread-bound session=" + session.hashCode());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionFactory getSessionFactory() {
        if (sessionFactory != null) return sessionFactory;
        Class<HibernateHelper> clazz = HibernateHelper.class;
        synchronized (HibernateHelper.class) {
            HibernateHelper.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sessionFactory;
        }
    }
}

